/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Notify;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_NOTIFY;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;

public class Token {
    private Slot slot;
    private boolean useUtf8Encoding;

    protected Token(Slot slot) {
        this.slot = Util.requireNonNull("slot", slot);
        this.useUtf8Encoding = slot.isUseUtf8Encoding();
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Token)) {
            return false;
        }
        Token other = (Token)otherObject;
        return this.slot.equals(other.slot);
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public long getTokenID() {
        return this.slot.getSlotID();
    }

    public TokenInfo getTokenInfo() throws TokenException {
        CK_TOKEN_INFO ckTokenInfo;
        try {
            ckTokenInfo = this.slot.getModule().getPKCS11Module().C_GetTokenInfo(this.slot.getSlotID());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new TokenInfo(ckTokenInfo);
    }

    public Mechanism[] getMechanismList() throws TokenException {
        long[] mechanismIdList;
        try {
            mechanismIdList = this.slot.getModule().getPKCS11Module().C_GetMechanismList(this.slot.getSlotID());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        Mechanism[] mechanisms = new Mechanism[mechanismIdList.length];
        for (int i = 0; i < mechanisms.length; ++i) {
            mechanisms[i] = new Mechanism(mechanismIdList[i]);
        }
        return mechanisms;
    }

    public MechanismInfo getMechanismInfo(Mechanism mechanism) throws TokenException {
        CK_MECHANISM_INFO ckMechanismInfo;
        long mechanismCode = mechanism.getMechanismCode();
        try {
            ckMechanismInfo = this.slot.getModule().getPKCS11Module().C_GetMechanismInfo(this.slot.getSlotID(), mechanismCode);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new MechanismInfo(ckMechanismInfo);
    }

    public int hashCode() {
        return this.slot.hashCode();
    }

    public Session openSession(boolean serialSession, boolean rwSession, Object application, final Notify notify) throws TokenException {
        long sessionHandle;
        long flags = 0L;
        flags |= serialSession ? 4L : 0L;
        flags |= rwSession ? 2L : 0L;
        final Session newSession = new Session(this, -1L);
        CK_NOTIFY ckNotify = null;
        if (notify != null) {
            ckNotify = new CK_NOTIFY(){

                @Override
                public void CK_NOTIFY(long hSession, long event, Object pApplication) throws sun.security.pkcs11.wrapper.PKCS11Exception {
                    boolean surrender = (event & 0L) != 0L;
                    notify.notify(newSession, surrender, pApplication);
                }
            };
        }
        try {
            sessionHandle = this.slot.getModule().getPKCS11Module().C_OpenSession(this.slot.getSlotID(), flags, application, ckNotify);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        newSession.setSessionHandle(sessionHandle);
        return newSession;
    }

    public String toString() {
        return Util.concatObjects("Token in Slot: ", this.slot);
    }

    public static interface SessionReadWriteBehavior {
        public static final boolean RO_SESSION = false;
        public static final boolean RW_SESSION = true;
    }

    public static interface SessionType {
        public static final boolean PARALLEL_SESSION = false;
        public static final boolean SERIAL_SESSION = true;
    }
}

