/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.SlotInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;

public class Slot {
    private Module module;
    private long slotID;
    private boolean useUtf8Encoding = true;

    protected Slot(Module module, long slotID) {
        this.module = Util.requireNonNull("module", module);
        this.slotID = slotID;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Slot)) {
            return false;
        }
        Slot other = (Slot)otherObject;
        return this.slotID == other.slotID && this.module.equals(other.module);
    }

    public void setUseUtf8Encoding(boolean useUtf8Encoding) {
        this.useUtf8Encoding = useUtf8Encoding;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public Module getModule() {
        return this.module;
    }

    public long getSlotID() {
        return this.slotID;
    }

    public SlotInfo getSlotInfo() throws TokenException {
        CK_SLOT_INFO ckSlotInfo;
        try {
            ckSlotInfo = this.module.getPKCS11Module().C_GetSlotInfo(this.slotID);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex);
        }
        return new SlotInfo(ckSlotInfo);
    }

    public Token getToken() throws TokenException {
        Token token = null;
        if (this.getSlotInfo().isTokenPresent()) {
            token = new Token(this);
        }
        return token;
    }

    public int hashCode() {
        return (int)this.slotID;
    }

    public String toString() {
        return Util.concatObjects("Slot ID: 0x", Long.toHexString(this.slotID), "\nModule: ", this.module);
    }
}

