/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;

public class MechanismInfo {
    protected long minKeySize;
    protected long maxKeySize;
    protected long flags;

    public MechanismInfo() {
    }

    public MechanismInfo(CK_MECHANISM_INFO ckMechanismInfo) {
        Util.requireNonNull("ckMechanismInfo", ckMechanismInfo);
        this.minKeySize = ckMechanismInfo.ulMinKeySize;
        this.maxKeySize = ckMechanismInfo.ulMaxKeySize;
        this.flags = ckMechanismInfo.flags;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof MechanismInfo)) {
            return false;
        }
        MechanismInfo other = (MechanismInfo)otherObject;
        return this.minKeySize == other.minKeySize && this.maxKeySize == other.maxKeySize && this.flags == other.flags;
    }

    public int hashCode() {
        return (int)(this.minKeySize ^ this.maxKeySize ^ this.flags);
    }

    public long getMinKeySize() {
        return this.minKeySize;
    }

    public long getMaxKeySize() {
        return this.maxKeySize;
    }

    public boolean isHw() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isEncrypt() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean isDecrypt() {
        return (this.flags & 0x200L) != 0L;
    }

    public boolean isDigest() {
        return (this.flags & 0x400L) != 0L;
    }

    public boolean isSign() {
        return (this.flags & 0x800L) != 0L;
    }

    public boolean isSignRecover() {
        return (this.flags & 0x1000L) != 0L;
    }

    public boolean isVerify() {
        return (this.flags & 0x2000L) != 0L;
    }

    public boolean isVerifyRecover() {
        return (this.flags & 0x4000L) != 0L;
    }

    public boolean isGenerate() {
        return (this.flags & 0x8000L) != 0L;
    }

    public boolean isGenerateKeyPair() {
        return (this.flags & 0x10000L) != 0L;
    }

    public boolean isWrap() {
        return (this.flags & 0x20000L) != 0L;
    }

    public boolean isUnwrap() {
        return (this.flags & 0x40000L) != 0L;
    }

    public boolean isDerive() {
        return (this.flags & 0x80000L) != 0L;
    }

    public boolean isEcFp() {
        return (this.flags & 0x100000L) != 0L;
    }

    public boolean isEcF2m() {
        return (this.flags & 0x200000L) != 0L;
    }

    public boolean isEcEcParameters() {
        return (this.flags & 0x400000L) != 0L;
    }

    public boolean isEcNamedCurve() {
        return (this.flags & 0x800000L) != 0L;
    }

    public boolean isEcUncompress() {
        return (this.flags & 0x1000000L) != 0L;
    }

    public boolean isEcCompress() {
        return (this.flags & 0x2000000L) != 0L;
    }

    public boolean isExtension() {
        return (this.flags & 0x80000000L) != 0L;
    }

    public void setMinKeySize(long minKeySize) {
        this.minKeySize = minKeySize;
    }

    public void setMaxKeySize(long maxKeySize) {
        this.maxKeySize = maxKeySize;
    }

    public void setHw(boolean hw) {
        this.setFlagBit(1L, hw);
    }

    public void setEncrypt(boolean encrypt) {
        this.setFlagBit(256L, encrypt);
    }

    public void setDecrypt(boolean decrypt) {
        this.setFlagBit(512L, decrypt);
    }

    public void setDigest(boolean digest) {
        this.setFlagBit(1024L, digest);
    }

    public void setSign(boolean sign) {
        this.setFlagBit(2048L, sign);
    }

    public void setSignRecover(boolean signRecover) {
        this.setFlagBit(4096L, signRecover);
    }

    public void setVerify(boolean verfy) {
        this.setFlagBit(8192L, verfy);
    }

    public void setVerifyRecover(boolean verifyRecover) {
        this.setFlagBit(16384L, verifyRecover);
    }

    public void setGenerate(boolean generate) {
        this.setFlagBit(32768L, generate);
    }

    public void setGenerateKeyPair(boolean generateKeyPair) {
        this.setFlagBit(65536L, generateKeyPair);
    }

    public void setWrap(boolean wrap) {
        this.setFlagBit(131072L, wrap);
    }

    public void setUnwrap(boolean unwrap) {
        this.setFlagBit(262144L, unwrap);
    }

    public void setDerive(boolean derive) {
        this.setFlagBit(524288L, derive);
    }

    public void setEcFp(boolean ecFp) {
        this.setFlagBit(0x100000L, ecFp);
    }

    public void setEcF2m(boolean ecF2m) {
        this.setFlagBit(0x200000L, ecF2m);
    }

    public void setEcEcParameters(boolean ecEcParameters) {
        this.setFlagBit(0x400000L, ecEcParameters);
    }

    public void setEcNamedCurve(boolean ecNamedCurve) {
        this.setFlagBit(0x800000L, ecNamedCurve);
    }

    public void setEcUncompress(boolean ecUncompress) {
        this.setFlagBit(0x1000000L, ecUncompress);
    }

    public void setEcCompress(boolean ecCompress) {
        this.setFlagBit(0x2000000L, ecCompress);
    }

    public void setExtension(boolean extension) {
        this.setFlagBit(0x80000000L, extension);
    }

    public boolean supports(MechanismInfo requiredFeatures) {
        Util.requireNonNull("requiredFeatures", requiredFeatures);
        long requiredMaxKeySize = requiredFeatures.getMaxKeySize();
        if (requiredMaxKeySize != 0L && requiredMaxKeySize > this.maxKeySize) {
            return false;
        }
        long requiredMinKeySize = requiredFeatures.getMinKeySize();
        if (requiredMinKeySize != 0L && requiredMinKeySize < this.minKeySize) {
            return false;
        }
        return (requiredFeatures.flags & this.flags) == requiredFeatures.flags;
    }

    public String toString() {
        return Util.concatObjectsCap(1024, "  Minimum Key-Size: ", this.minKeySize, "\n  Maximum Key-Size: ", this.maxKeySize, "\n  Hardware: ", this.isHw(), "\n  Encrypt: ", this.isEncrypt(), "\n  Decrypt: ", this.isDecrypt(), "\n  Digest: ", this.isDigest(), "\n  Sign: ", this.isSign(), "\n  Sign Recover: ", this.isSignRecover(), "\n  Verify: ", this.isVerify(), "\n  Verify Recover: ", this.isVerifyRecover(), "\n  Generate: ", this.isGenerate(), "\n  Generate Key-Pair: ", this.isGenerateKeyPair(), "\n  Wrap: ", this.isWrap(), "\n  Unwrap: ", this.isUnwrap(), "\n  Derive: ", this.isDerive(), "\n  EC F(p): ", this.isEcFp(), "\n  EC F(2^m): ", this.isEcF2m(), "\n  EC Parameters: ", this.isEcEcParameters(), "\n  EC Named Curve: ", this.isEcNamedCurve(), "\n  EC Uncompress: ", this.isEcUncompress(), "\n  EC Compress: ", this.isEcCompress(), "\n  Extension: ", this.isExtension());
    }

    private void setFlagBit(long flagMask, boolean value) {
        this.flags = value ? (this.flags |= flagMask) : (this.flags &= flagMask ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

