/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.constants.Functions;
import iaik.pkcs.pkcs11.params.Params;

public class Mechanism {
    protected long pkcs11MechanismCode;
    protected Params params;

    public Mechanism(long pkcs11MechanismCode) {
        this.pkcs11MechanismCode = pkcs11MechanismCode;
    }

    public static Mechanism get(long pkcs11MechanismCode) {
        return new Mechanism(pkcs11MechanismCode);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Mechanism)) {
            return false;
        }
        Mechanism other = (Mechanism)otherObject;
        if (this.pkcs11MechanismCode != other.pkcs11MechanismCode) {
            return false;
        }
        return Util.objEquals(this.params, other.params);
    }

    public int hashCode() {
        return (int)this.pkcs11MechanismCode;
    }

    public boolean isDigestMechanism() {
        return Functions.isDigestMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isFullEncryptDecryptMechanism() {
        return Functions.isFullEncryptDecryptMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isFullSignVerifyMechanism() {
        return Functions.isFullSignVerifyMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isKeyDerivationMechanism() {
        return Functions.isKeyDerivationMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isKeyGenerationMechanism() {
        return Functions.isKeyGenerationMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isKeyPairGenerationMechanism() {
        return Functions.isKeyPairGenerationMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isSignVerifyRecoverMechanism() {
        return Functions.isSignVerifyRecoverMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isSingleOperationEncryptDecryptMechanism() {
        return Functions.isSingleOperationEncryptDecryptMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isSingleOperationSignVerifyMechanism() {
        return Functions.isSingleOperationSignVerifyMechanism((long)this.pkcs11MechanismCode);
    }

    public boolean isWrapUnwrapMechanism() {
        return Functions.isWrapUnwrapMechanism((long)this.pkcs11MechanismCode);
    }

    public Params getParams() {
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public long getMechanismCode() {
        return this.pkcs11MechanismCode;
    }

    public String getName() {
        return Functions.mechanismCodeToString((long)this.pkcs11MechanismCode);
    }

    public String toString() {
        return Util.concatObjectsCap(128, "    Mechanism: ", Functions.mechanismCodeToString((long)this.pkcs11MechanismCode), "\n    Params:\n", this.params);
    }
}

