/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.NativeP11Module;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ModuleFactory;

public class NativeP11ModuleFactory
implements P11ModuleFactory {
    @Override
    public boolean canCreateModule(String type) {
        return "native".equalsIgnoreCase(type);
    }

    @Override
    public P11Module newModule(P11ModuleConf conf) throws TokenException {
        StaticLogger.setLogger((org.xipki.pkcs11.wrapper.Logger)P11Logger.INSTANCE);
        return NativeP11Module.getInstance(conf);
    }

    private static class P11Logger
    implements org.xipki.pkcs11.wrapper.Logger {
        private static final P11Logger INSTANCE = new P11Logger();
        private final Logger LOG = LoggerFactory.getLogger(org.xipki.pkcs11.wrapper.Logger.class);

        private P11Logger() {
        }

        public void info(String format, Object ... arguments) {
            this.LOG.info(format, arguments);
        }

        public void warn(String format, Object ... arguments) {
            this.LOG.warn(format, arguments);
        }

        public void error(String format, Object ... arguments) {
            this.LOG.error(format, arguments);
        }

        public void debug(String format, Object ... arguments) {
            this.LOG.debug(format, arguments);
        }

        public void trace(String format, Object ... arguments) {
            this.LOG.trace(format, arguments);
        }

        public boolean isTraceEnabled() {
            return this.LOG.isTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return this.LOG.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.LOG.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.LOG.isWarnEnabled();
        }
    }
}

