/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.Hex;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

class HashCalculator {
    private static final int PARALLELISM = 50;
    private static final ConcurrentHashMap<HashAlgo, ConcurrentBag<ConcurrentBagEntry<Digest>>> MDS_MAP = new ConcurrentHashMap();

    private HashCalculator() {
    }

    private static ConcurrentBag<ConcurrentBagEntry<Digest>> getMessageDigests(HashAlgo hashAlgo) {
        ConcurrentBag mds = new ConcurrentBag();
        for (int i = 0; i < 50; ++i) {
            mds.add(new ConcurrentBagEntry((Object)hashAlgo.createDigest()));
        }
        return mds;
    }

    public static String base64Sha1(byte[] ... datas) {
        return Base64.encodeToString((byte[])HashCalculator.hash(HashAlgo.SHA1, datas));
    }

    public static String base64Sha1(byte[] data, int offset, int len) {
        return Base64.encodeToString((byte[])HashCalculator.hash(HashAlgo.SHA1, data, offset, len));
    }

    public static String hexSha1(byte[] ... datas) {
        return Hex.encode((byte[])HashCalculator.hash(HashAlgo.SHA1, datas));
    }

    public static String hexSha1(byte[] data, int offset, int len) {
        return Hex.encode((byte[])HashCalculator.hash(HashAlgo.SHA1, data, offset, len));
    }

    public static byte[] sha1(byte[] ... datas) {
        return HashCalculator.hash(HashAlgo.SHA1, datas);
    }

    public static byte[] sha1(byte[] data, int offset, int len) {
        return HashCalculator.hash(HashAlgo.SHA1, data, offset, len);
    }

    public static String base64Sha256(byte[] ... datas) {
        return Base64.encodeToString((byte[])HashCalculator.hash(HashAlgo.SHA256, datas));
    }

    public static String base64Sha256(byte[] data, int offset, int len) {
        return Base64.encodeToString((byte[])HashCalculator.hash(HashAlgo.SHA256, data, offset, len));
    }

    public static String hexSha256(byte[] ... datas) {
        return Hex.encode((byte[])HashCalculator.hash(HashAlgo.SHA256, datas));
    }

    public static String hexSha256(byte[] data, int offset, int len) {
        return Hex.encode((byte[])HashCalculator.hash(HashAlgo.SHA256, data, offset, len));
    }

    public static byte[] sha256(byte[] ... datas) {
        return HashCalculator.hash(HashAlgo.SHA256, datas);
    }

    public static byte[] sha256(byte[] data, int offset, int len) {
        return HashCalculator.hash(HashAlgo.SHA256, data, offset, len);
    }

    public static String hexHash(HashAlgo hashAlgo, byte[] ... datas) {
        return Hex.encode((byte[])HashCalculator.hash(hashAlgo, datas));
    }

    public static String hexHash(HashAlgo hashAlgo, byte[] data, int offset, int len) {
        return Hex.encode((byte[])HashCalculator.hash(hashAlgo, data, offset, len));
    }

    public static String base64Hash(HashAlgo hashAlgo, byte[] ... datas) {
        return Base64.encodeToString((byte[])HashCalculator.hash(hashAlgo, datas));
    }

    public static String base64Hash(HashAlgo hashAlgo, byte[] data, int offset, int len) {
        return Base64.encodeToString((byte[])HashCalculator.hash(hashAlgo, data, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(HashAlgo hashAlgo, byte[] ... datas) {
        Args.notNull((Object)datas, (String)"datas");
        if (!MDS_MAP.containsKey(Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo"))) {
            throw new IllegalArgumentException("unknown hash algo " + hashAlgo);
        }
        ConcurrentBag<ConcurrentBagEntry<Digest>> mds = MDS_MAP.get((Object)hashAlgo);
        ConcurrentBagEntry md0 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                md0 = mds.borrow(10L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (md0 == null) {
            throw new RuntimeOperatorException("could not get idle MessageDigest");
        }
        try {
            Digest md = (Digest)md0.value();
            md.reset();
            for (byte[] data : datas) {
                if (data == null || data.length <= 0) continue;
                md.update(data, 0, data.length);
            }
            byte[] bytes = new byte[md.getDigestSize()];
            md.doFinal(bytes, 0);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            mds.requite(md0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(HashAlgo hashAlgo, byte[] data, int offset, int len) {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        if (((byte[])Args.notNull((Object)data, (String)"data")).length - offset < len) {
            throw new IndexOutOfBoundsException("data.length - offset < len");
        }
        if (!MDS_MAP.containsKey((Object)hashAlgo)) {
            throw new IllegalArgumentException("unknown hash algo " + hashAlgo);
        }
        ConcurrentBag<ConcurrentBagEntry<Digest>> mds = MDS_MAP.get((Object)hashAlgo);
        ConcurrentBagEntry md0 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                md0 = mds.borrow(10L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (md0 == null) {
            throw new RuntimeOperatorException("could not get idle MessageDigest");
        }
        try {
            Digest md = (Digest)md0.value();
            md.reset();
            md.update(data, offset, len);
            byte[] bytes = new byte[md.getDigestSize()];
            md.doFinal(bytes, 0);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            mds.requite(md0);
        }
    }

    static {
        for (HashAlgo ha : HashAlgo.values()) {
            MDS_MAP.put(ha, HashCalculator.getMessageDigests(ha));
        }
    }
}

