/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.ExpressionToken;
import org.xidea.el.Invocable;
import org.xidea.el.OperationStrategy;
import org.xidea.el.Reference;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.NumberArithmetic;
import org.xidea.el.impl.ReferenceImpl;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationStrategyImpl
implements OperationStrategy {
    private static final NumberArithmetic na = new NumberArithmetic();
    private static final Log log = LogFactory.getLog(OperationStrategyImpl.class);
    private final Map<Class<? extends Object>, Map<String, Invocable>> classMethodMap = new HashMap<Class<? extends Object>, Map<String, Invocable>>();
    private final Map<Object, Object> globalMap = new HashMap<Object, Object>();
    boolean customizable;

    public OperationStrategyImpl(boolean customizable) {
        this.customizable = customizable;
    }

    public Map<Object, Object> getGlobalMap() {
        return Collections.unmodifiableMap(this.globalMap);
    }

    protected void addVar(Object var, Object value) {
        this.globalMap.put(var, value);
    }

    protected void addMethod(Class<? extends Object> clazz, String name, Invocable invocable) {
        Map<String, Invocable> invocableMap = this.classMethodMap.get(clazz);
        if (invocableMap == null) {
            invocableMap = new HashMap<String, Invocable>();
            this.classMethodMap.put(clazz, invocableMap);
        }
        for (Map.Entry<Class<? extends Object>, Map<String, Invocable>> entry : this.classMethodMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            entry.getValue().put(name, invocable);
        }
    }

    protected boolean compare(Object arg1, Object arg2, int type) {
        if (arg1 == null) {
            if (arg2 == null) {
                return type == 335 || type == 334;
            }
        } else {
            if (arg1 instanceof Number && arg2 instanceof Number) {
                return na.compare((Number)arg1, (Number)arg2, type);
            }
            if (arg1.equals(arg2)) {
                return type == 335 || type == 334;
            }
        }
        arg1 = ECMA262Impl.ToPrimitive(arg1, Number.class);
        arg2 = ECMA262Impl.ToPrimitive(arg2, Number.class);
        if (arg1 instanceof String && arg2 instanceof String) {
            return na.compare(((String)arg1).compareTo((String)arg2), 0, type);
        }
        Number n1 = ECMA262Impl.ToNumber(arg1);
        Number n2 = ECMA262Impl.ToNumber(arg2);
        return na.compare(n1, n2, type);
    }

    protected boolean isEquals(Object arg1, Object arg2, boolean strict) {
        if (arg1 == null || arg2 == null) {
            return arg1 == arg2;
        }
        if (arg1 instanceof Number && arg2 instanceof Number) {
            return na.compare((Number)arg1, (Number)arg2, 76);
        }
        if (arg1.equals(arg2)) {
            return true;
        }
        if (strict) {
            if (arg1 instanceof String && arg2 instanceof String) {
                return false;
            }
            if (arg1 instanceof Boolean && arg2 instanceof Boolean) {
                return false;
            }
        }
        arg1 = ECMA262Impl.ToPrimitive(arg1, Number.class);
        arg2 = ECMA262Impl.ToPrimitive(arg2, Number.class);
        if (arg1 instanceof String && arg2 instanceof String) {
            return arg1.equals(arg2);
        }
        Number n1 = ECMA262Impl.ToNumber(arg1);
        Number n2 = ECMA262Impl.ToNumber(arg2);
        return na.compare(n1, n2, 76);
    }

    @Override
    public Object evaluate(ExpressionToken item, Map<String, Object> vs) {
        block54: {
            int type = item.getType();
            switch (type) {
                case -2: {
                    Object key = item.getParam();
                    return this.getVar(vs, key);
                }
                case -1: {
                    return item.getParam();
                }
                case -3: {
                    return new ArrayList();
                }
                case -4: {
                    return new LinkedHashMap();
                }
                case 33: 
                case 97: {
                    Object key;
                    Object thiz;
                    Object[] arguments = type == 97 ? ((List)this.evaluate(item.getRight(), vs)).toArray() : (Object[])item.getParam();
                    ExpressionToken left = item.getLeft();
                    int type2 = left.getType();
                    if (type2 == 96) {
                        thiz = this.evaluate(left.getLeft(), vs);
                        key = this.evaluate(left.getRight(), vs);
                    } else if (type2 == 32) {
                        thiz = this.evaluate(left.getLeft(), vs);
                        key = left.getRight().getParam();
                    } else {
                        return this.invoke(vs, this.evaluate(left, vs), arguments);
                    }
                    return this.invoke(vs, new ReferenceImpl(thiz, key), arguments);
                }
            }
            Object arg1 = this.evaluate(item.getLeft(), vs);
            Object arg2 = null;
            switch (type) {
                case 32: {
                    arg2 = item.getParam();
                    return ReflectUtil.getValue(arg1, arg2);
                }
                case 96: {
                    arg2 = this.evaluate(item.getRight(), vs);
                    return ReflectUtil.getValue(arg1, arg2);
                }
                case 328: {
                    if (ECMA262Impl.ToBoolean(arg1)) {
                        return this.evaluate(item.getRight(), vs);
                    }
                    return arg1;
                }
                case 72: {
                    if (ECMA262Impl.ToBoolean(arg1)) {
                        return arg1;
                    }
                    return this.evaluate(item.getRight(), vs);
                }
                case 69: {
                    ExpressionToken qtoken = (ExpressionToken)arg1;
                    if (ECMA262Impl.ToBoolean(this.evaluate(qtoken.getLeft(), vs))) {
                        return this.evaluate(qtoken.getRight(), vs);
                    }
                    return this.evaluate(item.getRight(), vs);
                }
                case 68: {
                    return item;
                }
            }
            if ((type & 0xC0) > 0) {
                arg2 = this.evaluate(item.getRight(), vs);
            }
            switch (type) {
                case 28: {
                    return !ECMA262Impl.ToBoolean(arg1);
                }
                case 30: {
                    return ECMA262Impl.ToNumber(arg1);
                }
                case 31: {
                    return na.subtract(0, ECMA262Impl.ToNumber(arg1));
                }
                case 84: {
                    Object p1 = ECMA262Impl.ToPrimitive(arg1, String.class);
                    Object p2 = ECMA262Impl.ToPrimitive(arg2, String.class);
                    if (p1 instanceof String || p1 instanceof Character) {
                        return p1 + ECMA262Impl.ToString(p2);
                    }
                    if (p2 instanceof String || p2 instanceof Character) {
                        return ECMA262Impl.ToString(p1) + p2;
                    }
                    return na.add(ECMA262Impl.ToNumber(p1), ECMA262Impl.ToNumber(p2));
                }
                case 85: {
                    return na.subtract(ECMA262Impl.ToNumber(arg1), ECMA262Impl.ToNumber(arg2));
                }
                case 88: {
                    return na.multiply(ECMA262Impl.ToNumber(arg1), ECMA262Impl.ToNumber(arg2));
                }
                case 89: {
                    return na.divide(ECMA262Impl.ToNumber(arg1), ECMA262Impl.ToNumber(arg2), true);
                }
                case 90: {
                    return na.modulus(ECMA262Impl.ToNumber(arg1), ECMA262Impl.ToNumber(arg2));
                }
                case 78: {
                    return this.isEquals(arg1, arg2, true);
                }
                case 76: {
                    return this.isEquals(arg1, arg2, false);
                }
                case 77: {
                    return !this.isEquals(arg1, arg2, false);
                }
                case 79: {
                    return !this.isEquals(arg1, arg2, true);
                }
                case 332: 
                case 333: 
                case 334: 
                case 335: {
                    return this.compare(arg1, arg2, type);
                }
                case 64: {
                    ((List)arg1).add(arg2);
                    return arg1;
                }
                case 65: {
                    ((Map)arg1).put(item.getParam(), arg2);
                    return arg1;
                }
                case 4428: {
                    return this.in(arg1, arg2);
                }
            }
            int a1 = ECMA262Impl.ToNumber(arg1).intValue();
            int a2 = ECMA262Impl.ToNumber(arg1).intValue();
            switch (type) {
                case 1096: {
                    return a1 & a2;
                }
                case 840: {
                    return a1 ^ a2;
                }
                case 584: {
                    return a1 | a2;
                }
                case 80: {
                    return a1 << a2;
                }
                case 81: {
                    return a1 >> a2;
                }
                case 82: {
                    return a1 >>> a2;
                }
            }
            Object impl = this.globalMap.get(type);
            if (impl != null) {
                Invocable method = (Invocable)impl;
                try {
                    return method.invoke(null, arg1, arg2);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block54;
                    log.debug((Object)("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25:" + arg1), (Throwable)e);
                }
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26" + item.getType());
    }

    protected boolean in(Object key, Object object) {
        int len = -1;
        Class<?> clazz = object.getClass();
        if (object instanceof List) {
            len = ((List)object).size();
        } else if (clazz.isArray()) {
            len = Array.getLength(object);
        }
        if (len >= 0) {
            if ("length".equals(key)) {
                return true;
            }
            Number n = ECMA262Impl.ToNumber(key);
            int i = n.intValue();
            if (i >= 0 && i < len) {
                return (float)i == n.floatValue();
            }
            return false;
        }
        String skey = ECMA262Impl.ToString(key);
        if (object instanceof Map) {
            return ((Map)object).containsKey(skey);
        }
        return ReflectUtil.getPropertyClass(clazz, skey) != null;
    }

    private Map<String, Invocable> requireMethodMap(Class<? extends Object> clazz) {
        Map<String, Invocable> methodMap = this.classMethodMap.get(clazz);
        if (methodMap == null) {
            Class<?>[] interfaces;
            methodMap = new HashMap<String, Invocable>();
            for (Class<?> clazz2 : interfaces = clazz.getInterfaces()) {
                Map<String, Invocable> m2 = this.requireMethodMap(clazz2);
                methodMap.putAll(m2);
            }
            Class<? extends Object> clazz2 = clazz.getSuperclass();
            if (clazz2 != clazz) {
                if (clazz2 == Object.class && clazz.isArray() && clazz != Object[].class) {
                    clazz2 = Object[].class;
                }
                if (clazz2 != null) {
                    Map<String, Invocable> m2 = this.requireMethodMap(clazz2);
                    methodMap.putAll(m2);
                }
            }
        }
        return methodMap;
    }

    protected Invocable getInvocable(Object base, String name, Object[] args) {
        Map<String, Invocable> mm = this.requireMethodMap(base.getClass());
        Invocable invocable = mm.get(name);
        if (invocable == null && name instanceof String && (invocable = ExpressionFactoryImpl.getInvocable(base.getClass(), name, args.length)) == null && base instanceof Class) {
            invocable = ExpressionFactoryImpl.getInvocable((Class)base, name, args.length);
        }
        return invocable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object invoke(Map<String, Object> vs, Object arg1, Object[] arguments) {
        try {
            Object thiz;
            Invocable invocable = null;
            if (arg1 instanceof Reference) {
                Object name;
                Reference pv = (Reference)arg1;
                thiz = pv.getBase();
                invocable = this.getInvocable(thiz, String.valueOf(name = pv.getName()), arguments);
                if (invocable != null) return invocable.invoke(thiz, arguments);
                arg1 = pv.getValue();
            } else {
                thiz = vs;
            }
            if (invocable != null) return invocable.invoke(thiz, arguments);
            if (arg1 instanceof Invocable) {
                invocable = (Invocable)arg1;
                return invocable.invoke(thiz, arguments);
            } else if (arg1 instanceof Method) {
                invocable = ExpressionFactoryImpl.createProxy((Method)arg1);
                return invocable.invoke(thiz, arguments);
            } else {
                if (!log.isInfoEnabled()) return invocable.invoke(thiz, arguments);
                log.info((Object)("\u5bf9\u8c61\u4e0d\u662f\u6709\u6548\u51fd\u6570:" + arg1));
            }
            return invocable.invoke(thiz, arguments);
        }
        catch (Exception e) {
            if (!log.isInfoEnabled()) return null;
            log.info((Object)("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25:" + arg1), (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getVar(Map<String, Object> vs, Object key) {
        Object o = vs.get(key);
        if (o == null) {
            return this.globalMap.get(key);
        }
        return o;
    }
}

