/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.ExpressionFactory;
import org.xidea.el.ExpressionSyntaxException;
import org.xidea.el.Reference;
import org.xidea.el.ReferenceExpression;
import org.xidea.el.impl.Convertor;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParser {
    private static final Log log = LogFactory.getLog(CommandParser.class);
    private static final ExpressionFactory factory = ExpressionFactoryImpl.getInstance();
    public Map<Class<?>, Convertor<? extends Object>> convertorMap = Convertor.DEFAULT_MAP;
    private Map<String, String[]> params;

    public CommandParser(String[] args) {
        if (args != null) {
            this.params = this.parseArgs(args);
        }
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String[]> params) {
        this.params = params;
    }

    public void addConvertor(Class<? extends Object> clazz, Convertor<? extends Object> convertor) {
        if (!(this.convertorMap instanceof HashMap)) {
            this.convertorMap = new HashMap(this.convertorMap);
        }
        this.convertorMap.put(clazz, convertor);
    }

    public static void setup(Object result, String[] args) {
        CommandParser parser = new CommandParser(args);
        parser.setup(result);
    }

    public void setup(Object context) {
        this.setup(context, this.params);
    }

    public void setup(Object context, Map<String, String[]> params) {
        for (String name : params.keySet()) {
            if (name == null || name.length() <= 0 || !Character.isJavaIdentifierStart(name.charAt(0))) continue;
            try {
                ReferenceExpression el = this.getReference(name);
                Reference result = el.prepare(context);
                if (result != null && result.getType() != null) {
                    Class<? extends Object> type = result.getType();
                    String[] values = params.get(name);
                    result.setValue(this.getValue(values, type, context, name));
                    continue;
                }
                if (context == null) continue;
                this.onMissedProperty(context, name);
            }
            catch (ExpressionSyntaxException e) {
                log.debug((Object)("\u65e0\u6548\u5c5e\u6027\uff1a" + name), (Throwable)e);
            }
        }
    }

    protected void onMissedProperty(Object context, String name) {
        if (log.isInfoEnabled()) {
            String msg = "\u627e\u4e0d\u5230\u76f8\u5173\u5c5e\u6027\uff1a" + name + "; \u5f53\u524d\u5bf9\u8c61\u53ef\u80fd\u5c5e\u6027\u6709\uff1a" + ReflectUtil.map(context).keySet();
            log.info((Object)msg);
        }
    }

    private ReferenceExpression getReference(String name) {
        ReferenceExpression el = (ReferenceExpression)((Object)factory.create(name));
        return el;
    }

    protected Map<String, String[]> parseArgs(String[] args) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                name = arg.substring(1);
                continue;
            }
            ArrayList<String> values = (ArrayList<String>)result.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                result.put(name, (String[])values);
            }
            values.add(arg);
        }
        Iterator iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = iterator.next();
            List value = (List)entry.getValue();
            entry.setValue(value.toArray(new String[value.size()]));
        }
        return result;
    }

    public <T> T getValue(String[] values, Class<? extends T> expectedType, Object context, String key) {
        if (expectedType.isArray()) {
            Class<?> ct = expectedType.getComponentType();
            Object result = Array.newInstance(ct, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(result, i, this.getValue(values[i], ct, context, key));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(expectedType)) {
            Collection<String> buf;
            if (expectedType.isAssignableFrom(ArrayList.class)) {
                buf = new ArrayList();
            } else if (expectedType.isAssignableFrom(HashSet.class)) {
                buf = new HashSet();
            } else {
                try {
                    buf = (Collection)expectedType.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("\u521b\u5efa\u5bf9\u8c61\u5931\u8d25" + expectedType.getName()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            for (int i = 0; i < values.length; ++i) {
                buf.add(values[i]);
            }
            return (T)buf;
        }
        return this.getValue(values[values.length - 1], expectedType, context, key);
    }

    public <T> T getValue(String value, Class<? extends T> expectedType, Object context, String key) {
        Convertor<? extends Object> c = this.convertorMap.get(expectedType);
        if (c != null) {
            return c.getValue(value, expectedType, context, key);
        }
        log.error((Object)("unsuport type:" + expectedType + ":" + key));
        return null;
    }

    public String toString() {
        if (this.params == null) {
            return "*EMPTY*";
        }
        StringBuilder buf = new StringBuilder();
        for (String key : this.params.keySet()) {
            buf.append(key);
            buf.append("=>\n");
            String[] list = this.params.get(key);
            if (this.params == null) continue;
            for (String value : list) {
                buf.append("\t");
                buf.append(value);
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

