/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.fn;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.xidea.el.fn.JSArray;
import org.xidea.el.fn.JSGlobal;
import org.xidea.el.fn.JSNumber;
import org.xidea.el.fn.JSObject;
import org.xidea.el.fn.JSString;
import org.xidea.el.impl.ExpressionFactoryImpl;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECMA262Impl {
    private static final Class<?>[] ARRAY_CLASSES = new Class[]{List.class, Object[].class, int[].class, float[].class, double[].class, long[].class, short[].class, byte[].class, char[].class};

    public static void setup(ExpressionFactoryImpl calculater) {
        ECMA262Impl.setup(calculater, JSArray.class, ARRAY_CLASSES);
        ECMA262Impl.setup(calculater, JSNumber.class, Number.class);
        ECMA262Impl.setup(calculater, JSString.class, String.class);
        JSGlobal.setupVar(calculater);
    }

    private static void setup(ExpressionFactoryImpl calculater, Class<? extends JSObject> impl, Class<?> ... forClass) {
        try {
            Method[] dms;
            for (Method method : dms = impl.getMethods()) {
                if (method.getDeclaringClass() != impl) continue;
                JSObject inv = impl.newInstance();
                Class<?>[] params = method.getParameterTypes();
                inv.method = method;
                if (params.length != 2 || params[1] != Object[].class) {
                    inv.params = params;
                }
                try {
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (Class<?> type : forClass) {
                    calculater.addMethod(type, method.getName(), inv);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Number parseInt(String text, int radix) {
        try {
            return Integer.parseInt(text, radix);
        }
        catch (Exception e) {
            return Long.parseLong(text, radix);
        }
    }

    public static boolean ToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            float f = ((Number)value).floatValue();
            return f != 0.0f && !Float.isNaN(f);
        }
        if (value instanceof String) {
            return ((String)value).length() > 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public static Number ToNumber(Object value) {
        if ((value = ECMA262Impl.ToPrimitive(value, String.class)) == null) {
            return 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String text = (String)value;
        try {
            if (text.indexOf(46) >= 0) {
                return Float.valueOf(Float.parseFloat(text));
            }
            if (text.length() > 1) {
                boolean isNavigate;
                char c1 = text.charAt(0);
                char c2 = text.charAt(1);
                boolean bl = isNavigate = c1 == '-';
                if (isNavigate || c1 == '+') {
                    c1 = c2;
                    if (text.length() > 2) {
                        c2 = text.charAt(2);
                    }
                }
                if (c1 == '0') {
                    if (c2 == 'x' || c2 == 'X') {
                        return ECMA262Impl.parseInt(text.charAt(0) + text.substring(text.indexOf(c2) + 1), 16);
                    }
                    return ECMA262Impl.parseInt(text, 10);
                }
                if (text.indexOf(69) > 0 || text.indexOf(101) > 0) {
                    return Float.valueOf(Float.parseFloat(text));
                }
            }
            return ECMA262Impl.parseInt(text, 10);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    public static Object ToPrimitive(Object value, Class<?> expectedType) {
        boolean toString;
        if (expectedType == Number.class) {
            toString = false;
        } else if (expectedType == String.class) {
            toString = true;
        } else if (expectedType == null) {
            toString = !(value instanceof Date);
        } else {
            throw new IllegalArgumentException("expectedType \u53ea\u80fd\u662f Number\u6216\u8005String");
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (toString) {
            return String.valueOf(value);
        }
        if (value instanceof Date) {
            return new Long(((Date)value).getTime());
        }
        return String.valueOf(value);
    }

    public static Object ToValue(Object value, Class<?> type) {
        if (type == String.class) {
            return value == null ? null : value.toString();
        }
        if (type == Character.class) {
            if (value == null) {
                return Character.valueOf('\u0000');
            }
            if ((value = ECMA262Impl.ToPrimitive(value, String.class)) instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            String text = (String)value;
            if (text.length() > 0) {
                return Character.valueOf(text.charAt(0));
            }
            return 0;
        }
        if (Number.class.isAssignableFrom(type = ReflectUtil.toWrapper(type))) {
            Number n = ECMA262Impl.ToNumber(value);
            return ReflectUtil.toValue(n, type);
        }
        if (type == Boolean.class) {
            return ECMA262Impl.ToBoolean(ECMA262Impl.ToPrimitive(value, type));
        }
        return value;
    }

    public static String ToString(Object value) {
        if ((value = ECMA262Impl.ToPrimitive(value, String.class)) instanceof Number) {
            return ECMA262Impl.toString((Number)value, 10);
        }
        return String.valueOf(value);
    }

    static String toString(Number thiz, int radix) {
        if (radix <= 0 || radix > 36) {
            radix = 10;
        }
        if (thiz instanceof Double || thiz instanceof Float) {
            return ECMA262Impl.floatToString(thiz.doubleValue(), radix);
        }
        return Long.toString(thiz.longValue(), radix);
    }

    private static String floatToString(double d, int base) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base == 10) {
            String result = Double.toString(d);
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            return result;
        }
        return Long.toString((long)d, base);
    }
}

