/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.impl.GenericFinder;
import org.xidea.el.impl.ProxyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static final Log log = LogFactory.getLog(ReflectUtil.class);
    private static final String LENGTH = "length";
    private static final Map<Class<?>, Map<String, Method>> readerMap = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Method>> writerMap = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Type[]>> typeMap = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Map<String, Field>> fieldMap = (Map)ReflectUtil.newMap();
    private static final Map<Class<?>, Constructor<?>> constructorMap = (Map)ReflectUtil.newMap();
    private static final Map<Class<? extends Enum<?>>, Enum<?>[]> enumMap = (Map)ReflectUtil.newMap();
    private static Object initLock = new Object();

    private static <T> T newMap() {
        return (T)new HashMap();
    }

    public static Map<String, Method> getGetterMap(Class<?> clazz) {
        Map<String, Method> propertyMap = readerMap.get(clazz);
        if (propertyMap == null) {
            ReflectUtil.initProperties(clazz);
            propertyMap = readerMap.get(clazz);
        }
        return propertyMap;
    }

    public static Map<String, Method> getSetterMap(Class<?> clazz) {
        Map<String, Method> propertyMap = writerMap.get(clazz);
        if (propertyMap == null) {
            ReflectUtil.initProperties(clazz);
            propertyMap = writerMap.get(clazz);
        }
        return propertyMap;
    }

    private static Map<String, Type[]> getTypeMap(Class<?> clazz) {
        Map<String, Type[]> tMap = typeMap.get(clazz);
        if (tMap == null) {
            ReflectUtil.initProperties(clazz);
            tMap = typeMap.get(clazz);
        }
        return tMap;
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        Map<String, Field> fMap = fieldMap.get(clazz);
        if (fMap == null) {
            ReflectUtil.initProperties(clazz);
            fMap = fieldMap.get(clazz);
        }
        return fMap;
    }

    public static Set<String> getPropertySet(Class<?> clazz) {
        return ReflectUtil.getTypeMap(clazz).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProperties(Class<?> clazz) {
        Object object = initLock;
        synchronized (object) {
            try {
                Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                if (!cons.isAccessible()) {
                    cons.setAccessible(true);
                }
                constructorMap.put(clazz, cons);
            }
            catch (Exception e) {
                // empty catch block
            }
            HashMap<String, Method> getterMap = new HashMap<String, Method>();
            HashMap<String, Method> setterMap = new HashMap<String, Method>();
            HashMap<String, Type[]> propertyMap = new HashMap<String, Type[]>();
            HashMap<String, Field> fieldMap_ = new HashMap<String, Field>();
            try {
                Field[] fields;
                String name;
                Method[] methods;
                if (!clazz.equals(Object.class)) {
                    getterMap.putAll(ReflectUtil.getGetterMap(clazz.getSuperclass()));
                    setterMap.putAll(ReflectUtil.getSetterMap(clazz.getSuperclass()));
                    propertyMap.putAll(ReflectUtil.getTypeMap(clazz.getSuperclass()));
                    fieldMap_.putAll(ReflectUtil.getFieldMap(clazz.getSuperclass()));
                }
                for (Method m : methods = clazz.getDeclaredMethods()) {
                    if ((m.getModifiers() & 1) <= 0) continue;
                    Class<?> type = m.getReturnType();
                    Class<?>[] params = m.getParameterTypes();
                    name = m.getName();
                    if (type == Void.TYPE) {
                        if (params.length != 1 || !name.startsWith("set")) continue;
                        type = params[0];
                        ReflectUtil.initMethod(setterMap, propertyMap, m, name.substring(3));
                        continue;
                    }
                    if (params.length != 0) continue;
                    if (name.startsWith("get") && !name.equals("getClass")) {
                        ReflectUtil.initMethod(getterMap, propertyMap, m, name.substring(3));
                        continue;
                    }
                    if (type != Boolean.TYPE || !name.startsWith("is")) continue;
                    ReflectUtil.initMethod(getterMap, propertyMap, m, name.substring(2));
                }
                boolean isMemberAndNoGetterSetter = clazz.isMemberClass() && getterMap.isEmpty() && setterMap.isEmpty();
                for (Field f : fields = clazz.getDeclaredFields()) {
                    f.setAccessible(true);
                    name = f.getName();
                    if (!isMemberAndNoGetterSetter && (f.getModifiers() & 1) <= 0) continue;
                    propertyMap.put(name, new Type[]{GenericFinder.Default.getGenericType(f), clazz});
                    fieldMap_.put(name, f);
                }
            }
            catch (Exception e) {
                log.warn((Object)"\u521d\u59cb\u5316\u5c5e\u6027\u96c6\u5408\u5f02\u5e38", (Throwable)e);
            }
            finally {
                readerMap.put(clazz, Collections.unmodifiableMap(getterMap));
                writerMap.put(clazz, Collections.unmodifiableMap(setterMap));
                typeMap.put(clazz, Collections.unmodifiableMap(propertyMap));
                fieldMap.put(clazz, Collections.unmodifiableMap(fieldMap_));
            }
        }
    }

    private static void initMethod(Map<String, Method> propertyMap, Map<String, Type[]> typeMap, Method m, String name) {
        char c;
        if (name.length() > 0 && Character.isUpperCase(c = name.charAt(0))) {
            Type[] ot;
            name = Character.toLowerCase(c) + name.substring(1);
            m.setAccessible(true);
            propertyMap.put(name, m);
            Class<?> type = GenericFinder.Default.getGenericReturnType(m);
            if (type == Void.TYPE) {
                type = m.getParameterTypes()[0];
            }
            if ((ot = typeMap.get(name)) != null && ot[0] != type) {
                log.warn((Object)("\u5c5e\u6027\u7c7b\u578b\u51b2\u7a81\uff1a" + ot + "!=" + type));
            }
            typeMap.put(name, new Type[]{type, m.getDeclaringClass()});
        }
    }

    public static Map<String, ? extends Object> map(Object context) {
        if (context == null) {
            return Collections.EMPTY_MAP;
        }
        if (context instanceof Map) {
            return (Map)context;
        }
        return new ProxyMap(context, ReflectUtil.getTypeMap(context.getClass()).keySet());
    }

    private static int toIndex(Object key) {
        return key instanceof Number ? ((Number)key).intValue() : Integer.parseInt(String.valueOf(key));
    }

    public static Class<? extends Object> getValueType(Type type) {
        Type result = null;
        Class clazz = null;
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        if (Collection.class.isAssignableFrom(clazz)) {
            result = ReflectUtil.getParameterizedType(type, Collection.class, 0);
        } else if (Map.class.isAssignableFrom(clazz)) {
            result = ReflectUtil.getParameterizedType(type, Map.class, 1);
        }
        if (result != null) {
            return ReflectUtil.baseClass(result);
        }
        return Object.class;
    }

    public static Class<?> getKeyType(Type type) {
        Type result;
        Class clazz = null;
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        if (Map.class.isAssignableFrom(clazz) && (result = ReflectUtil.getParameterizedType(type, Map.class, 0)) != null) {
            return ReflectUtil.baseClass(result);
        }
        return Integer.TYPE;
    }

    public static Type getParameterizedType(Type ownerType, Class<?> declaredClass, int paramIndex) {
        return GenericFinder.Default.getParameterizedType(ownerType, declaredClass, paramIndex);
    }

    /*
     * Loose catch block
     */
    public static <T> T newInstance(Class<T> clazz) {
        block8: {
            Constructor<?> cons = constructorMap.get(clazz);
            if (cons == null) break block8;
            ReflectUtil.initProperties(clazz);
            cons = constructorMap.get(clazz);
            if (cons == null) break block8;
            return (T)cons.newInstance(new Object[0]);
            {
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            block9: {
                try {
                    Constructor<T> cuns = clazz.getDeclaredConstructor(new Class[0]);
                    if (!cuns.isAccessible()) {
                        cuns.setAccessible(true);
                        constructorMap.put(clazz, cuns);
                        return cuns.newInstance(new Object[0]);
                    }
                }
                catch (NoSuchMethodException ne) {
                    if (!clazz.isMemberClass()) break block9;
                    log.error((Object)("\u5185\u90e8\u5185 class " + clazz + " \u65e0\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\uff0c\u65e0\u6cd5\u521b\u5efa\uff08\u975estatic\u7684\u5185\u90e8\u5185\uff0c\u4e0d\u53ef\u80fd\u62e5\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\uff09\u3002"));
                }
            }
            return null;
        }
    }

    public static Class<? extends Object> baseClass(Type result) {
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof ParameterizedType) {
            return ReflectUtil.baseClass(((ParameterizedType)result).getRawType());
        }
        if (result instanceof WildcardType) {
            return ReflectUtil.baseClass(((WildcardType)result).getUpperBounds()[0]);
        }
        return null;
    }

    public static <T extends Enum<?>> T getEnum(Object value, Class<T> clazz) {
        if (value instanceof String) {
            Class<T> clazz2 = clazz;
            return Enum.valueOf(clazz2, (String)value);
        }
        if (value instanceof Number) {
            Enum<?>[] es = enumMap.get(clazz);
            try {
                if (es == null) {
                    Method method = clazz.getMethod("values", new Class[0]);
                    es = (Enum[])method.invoke(null, new Object[0]);
                    enumMap.put(clazz, es);
                }
                int i = ((Number)value).intValue();
                return (T)es[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Class<?> getPropertyClass(Type type, Object key) {
        return ReflectUtil.baseClass(ReflectUtil.getPropertyType(type, key));
    }

    public static Type getPropertyType(Type ownerType, Object key) {
        Class<? extends Object> clazz = ReflectUtil.baseClass(ownerType);
        if (clazz != null) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return ReflectUtil.getValueType(ownerType);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return ReflectUtil.getValueType(ownerType);
            }
            if (clazz.isArray()) {
                if (LENGTH.equals(key)) {
                    return Integer.TYPE;
                }
                if (Number.class.isInstance(key)) {
                    return clazz.getComponentType();
                }
            } else {
                Type[] typeAndClass = ReflectUtil.getTypeMap(clazz).get(String.valueOf(key));
                if (typeAndClass != null) {
                    return GenericFinder.Default.getParameterizedType(ownerType, (Class)typeAndClass[1], typeAndClass[0]);
                }
            }
        }
        return null;
    }

    public static Object getValue(Object context, Object key) {
        block16: {
            Class<?> clazz = context.getClass();
            if (context != null) {
                try {
                    if (context instanceof Map) {
                        return ((Map)context).get(key);
                    }
                    if (key instanceof String) {
                        Method method = ReflectUtil.getGetterMap(clazz).get((String)key);
                        if (method == null) {
                            Field field = context instanceof Class ? ReflectUtil.getFieldMap((Class)context).get(key) : ReflectUtil.getFieldMap(clazz).get(key);
                            if (field != null) {
                                return field.get(context);
                            }
                        } else {
                            return method.invoke(context, new Object[0]);
                        }
                        if (LENGTH.equals(key)) {
                            if (clazz.isArray()) {
                                return Array.getLength(context);
                            }
                            if (context instanceof Collection) {
                                return ((Collection)context).size();
                            }
                            if (context instanceof String) {
                                return ((String)context).length();
                            }
                        }
                        if (context instanceof Map) {
                            return ((Map)context).get(key);
                        }
                        if (clazz.isArray()) {
                            return Array.getLength(context);
                        }
                        return Array.get(context, ReflectUtil.toIndex(key));
                    }
                    if (context instanceof List) {
                        return ((List)context).get(ReflectUtil.toIndex(key));
                    }
                    if (clazz.isArray()) {
                        return Array.get(context, ReflectUtil.toIndex(key));
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block16;
                    log.debug((Object)e);
                }
            }
        }
        return null;
    }

    public static void setValues(Object base, Map<String, Object> attributeMap) {
        for (String key : attributeMap.keySet()) {
            ReflectUtil.setValue(base, key, attributeMap.get(key));
        }
    }

    public static void setValue(Object base, Object key, Object value) {
        block11: {
            if (base != null) {
                try {
                    Class<?> clazz = base.getClass();
                    if (clazz.isArray()) {
                        Array.set(base, ReflectUtil.toIndex(key), value);
                    } else if (base instanceof List) {
                        ((List)base).set(ReflectUtil.toIndex(key), value);
                    }
                    if (base instanceof Map) {
                        ((Map)base).put(key, value);
                    }
                    String name = String.valueOf(key);
                    Method method = ReflectUtil.getSetterMap(clazz).get(name);
                    if (method != null) {
                        if (value != null) {
                            Class<?> type = method.getParameterTypes()[0];
                            value = ReflectUtil.toWrapper(value, type);
                        }
                        method.invoke(base, value);
                    } else {
                        Field field = fieldMap.get(clazz).get(name);
                        if (value != null) {
                            Class<?> type = field.getType();
                            value = ReflectUtil.toWrapper(value, type);
                        }
                        field.set(base, value);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)e);
                }
            }
        }
    }

    private static Object toWrapper(Object value, Class<?> type) {
        if (!type.isInstance(value) && Number.class.isAssignableFrom(type = ReflectUtil.toWrapper(type))) {
            value = ReflectUtil.toValue((Number)value, type);
        }
        return value;
    }

    public static Number toValue(Number value, Class<? extends Object> type) {
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == Integer.class) {
            return value.intValue();
        }
        if (type == Short.class) {
            return value.shortValue();
        }
        if (type == Byte.class) {
            return value.byteValue();
        }
        if (type == Double.class) {
            return value.doubleValue();
        }
        if (type == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        Class<? extends Object> clazz = ReflectUtil.toWrapper(type);
        if (clazz == type) {
            return null;
        }
        return ReflectUtil.toValue(value, clazz);
    }

    public static final Class<? extends Object> toWrapper(Class<? extends Object> type) {
        if (type.isPrimitive()) {
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
        }
        return type;
    }

    public static void setGenericFinder(GenericFinder finder) {
        GenericFinder.Default.finder = finder;
    }
}

