/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

class NumberArithmetic {
    private static final Class<?>[] NUMBER_CLASS = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};

    NumberArithmetic() {
    }

    private static final int getNumberType(Number n1, Number n2) {
        Class<?> c1 = n1.getClass();
        Class<?> c2 = n2.getClass();
        int i = NUMBER_CLASS.length;
        while (i-- > 0) {
            Class<?> c = NUMBER_CLASS[i];
            if (c != c1 && c != c2) continue;
            return i;
        }
        return NUMBER_CLASS.length - 1;
    }

    public boolean compare(Number n1, Number n2, int type) {
        double d1 = n1.doubleValue();
        double d2 = n2.doubleValue();
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return type == 77 || type == 79;
        }
        long i = Double.compare(d1, d2);
        switch (type) {
            case 333: {
                return i > 0L;
            }
            case 335: {
                return i >= 0L;
            }
            case 332: {
                return i < 0L;
            }
            case 334: {
                return i <= 0L;
            }
            case 76: 
            case 78: {
                return i == 0L;
            }
            case 77: 
            case 79: {
                return i != 0L;
            }
        }
        throw new IllegalStateException("\u65e0\u6548\u6bd4\u8f83\u7c7b\u578b:" + type);
    }

    public Number add(Number n1, Number n2) {
        switch (NumberArithmetic.getNumberType(n1, n2)) {
            case 0: 
            case 1: 
            case 2: {
                return n1.intValue() + n2.intValue();
            }
            case 3: {
                return n1.longValue() + n2.longValue();
            }
            case 4: {
                return Float.valueOf(n1.floatValue() + n2.floatValue());
            }
        }
        return n1.doubleValue() + n2.doubleValue();
    }

    public Number subtract(Number n1, Number n2) {
        switch (NumberArithmetic.getNumberType(n1, n2)) {
            case 0: 
            case 1: 
            case 2: {
                return n1.intValue() - n2.intValue();
            }
            case 3: {
                return n1.longValue() - n2.longValue();
            }
            case 4: {
                return Float.valueOf(n1.floatValue() - n2.floatValue());
            }
        }
        return n1.doubleValue() - n2.doubleValue();
    }

    public Number multiply(Number n1, Number n2) {
        switch (NumberArithmetic.getNumberType(n1, n2)) {
            case 0: 
            case 1: 
            case 2: {
                return n1.intValue() * n2.intValue();
            }
            case 3: {
                return n1.longValue() * n2.longValue();
            }
            case 4: {
                return Float.valueOf(n1.floatValue() * n2.floatValue());
            }
        }
        return n1.doubleValue() * n2.doubleValue();
    }

    public Number divide(Number n1, Number n2, boolean exact) {
        switch (NumberArithmetic.getNumberType(n1, n2)) {
            case 0: 
            case 1: 
            case 2: {
                return n1.doubleValue() / n2.doubleValue();
            }
            case 3: {
                return n1.doubleValue() / n2.doubleValue();
            }
            case 4: {
                return Float.valueOf(n1.floatValue() / n2.floatValue());
            }
        }
        return n1.doubleValue() / n2.doubleValue();
    }

    public Number modulus(Number n1, Number n2) {
        switch (NumberArithmetic.getNumberType(n1, n2)) {
            case 0: 
            case 1: 
            case 2: {
                return n1.intValue() % n2.intValue();
            }
            case 3: {
                return n1.longValue() % n2.longValue();
            }
            case 4: {
                return Float.valueOf(n1.floatValue() % n2.floatValue());
            }
        }
        return n1.doubleValue() % n2.doubleValue();
    }
}

