/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.aboutbox;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.demo.aboutbox.DemoMarker;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;

@ParametersAreNonnullByDefault
public class DemoUserAgent
implements UserAgentCallback {
    private static final Logger log = LoggerFactory.getLogger(DemoUserAgent.class);
    private String baseUrl;
    private int index = -1;
    private final List<String> history = new ArrayList<String>();
    private final int imageCacheCapacity = 16;
    private final Map<String, ImageResource> imageCache = new LinkedHashMap<String, ImageResource>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ImageResource> eldest) {
            return this.size() > 16;
        }
    };

    public CSSResource getCSSResource(String resourceUri) {
        String uri = this.resolveURI(resourceUri);
        try {
            URLConnection uc = new URL(uri).openConnection();
            uc.connect();
            return new CSSResource(uc.getInputStream());
        }
        catch (MalformedURLException e) {
            XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
        }
        catch (IOException e) {
            XRLog.exception((String)("IO problem for " + uri), (Throwable)e);
        }
        return new CSSResource(null);
    }

    public ImageResource getImageResource(String uri) {
        ImageResource ir = this.imageCache.get(uri = this.resolveURI(uri));
        if (ir == null) {
            InputStream is = null;
            try {
                URLConnection uc = new URL(uri).openConnection();
                uc.connect();
                is = uc.getInputStream();
            }
            catch (MalformedURLException e1) {
                XRLog.exception((String)("bad URL given: " + uri), (Throwable)e1);
            }
            catch (IOException e11) {
                XRLog.exception((String)("IO problem for " + uri), (Throwable)e11);
            }
            if (is != null) {
                try {
                    BufferedImage img = ImageIO.read(is);
                    ir = new ImageResource(uri, AWTFSImage.createImage((Image)img));
                    this.imageCache.put(uri, ir);
                }
                catch (IOException e) {
                    XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
                }
            }
        }
        if (ir == null) {
            ir = new ImageResource(uri, null);
        }
        return ir;
    }

    @Nullable
    @CheckReturnValue
    public byte[] getBinaryResource(String uri) {
        return IOUtil.readBytes((String)uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public XMLResource getXMLResource(String uri) {
        XMLResource xr;
        block11: {
            if ((uri = this.resolveURI(uri)) != null && uri.startsWith("file:")) {
                try {
                    new File(new URI(uri));
                }
                catch (URISyntaxException e) {
                    log.error("Failed to read xml resource {}", (Object)uri, (Object)e);
                }
            }
            xr = null;
            InputStream inputStream = null;
            try {
                URLConnection uc = new URL(uri).openConnection();
                uc.connect();
                inputStream = uc.getInputStream();
                xr = XMLResource.load((InputStream)inputStream);
                IOUtil.close((Closeable)inputStream);
            }
            catch (MalformedURLException e) {
                XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
            }
            catch (IOException e2) {
                XRLog.exception((String)("IO problem for " + uri), (Throwable)e2);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(inputStream);
            }
        }
        if (xr == null) {
            String notFound = "<h1>Document not found</h1>";
            xr = XMLResource.load((Reader)new StringReader(notFound));
        }
        return xr;
    }

    @CheckReturnValue
    public boolean isVisited(@Nullable String uri) {
        if (uri == null) {
            return false;
        }
        uri = this.resolveURI(uri);
        return this.history.contains(uri);
    }

    public void setBaseURL(String url) {
        String historic;
        this.baseUrl = this.resolveURI(url);
        if (this.baseUrl == null) {
            this.baseUrl = "error:FileNotFound";
        }
        if (this.index >= 0 && (historic = this.history.get(this.index)).equals(this.baseUrl)) {
            return;
        }
        ++this.index;
        int i = this.index;
        while (i < this.history.size()) {
            this.history.remove(i);
        }
        this.history.add(this.index, this.baseUrl);
    }

    @Nullable
    @CheckReturnValue
    public String resolveURI(@Nullable String uri) {
        URL ref = null;
        if (uri == null) {
            return this.baseUrl;
        }
        if (uri.trim().isEmpty()) {
            return this.baseUrl;
        }
        if (uri.startsWith("demo:")) {
            DemoMarker marker = new DemoMarker();
            Object short_url = uri.substring(5);
            if (!((String)short_url).startsWith("/")) {
                short_url = "/" + (String)short_url;
            }
            ref = marker.getClass().getResource((String)short_url);
            Uu.p((String)("ref = " + ref));
        } else {
            try {
                if (this.baseUrl == null || this.baseUrl.isEmpty()) {
                    ref = new URL(uri);
                } else {
                    URL base = new URL(this.baseUrl);
                    ref = new URL(base, uri);
                }
            }
            catch (MalformedURLException e) {
                log.error("Failed to resolve uri {}", (Object)uri, (Object)e);
            }
        }
        if (ref == null) {
            return null;
        }
        return ref.toExternalForm();
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public String getForward() {
        ++this.index;
        return this.history.get(this.index);
    }

    public String getBack() {
        --this.index;
        return this.history.get(this.index);
    }

    public boolean hasForward() {
        return this.index + 1 < this.history.size() && this.index >= 0;
    }

    public boolean hasBack() {
        return this.index >= 0;
    }
}

