/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.docbook;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.Java2DTextRenderer;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.XRLog;

public class ShowDocBookPage {
    public JFrame frame;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            String uri = "/docbook/xml/plugin-implement.xml";
            if (args.length > 0) {
                uri = args[0];
            }
            new ShowDocBookPage().run(uri);
        });
    }

    private static void usage(int i, String reason) {
        String s = "org.xhtmlrenderer.demo.docbook.ShowDocbookPage\nSimple example to render a single DocBook XML page, using only CSS, in a Swing JFrame/JPanel using Flying Saucer.\n\nUsage: \n      java org.xhtmlrenderer.demo.docbook.ShowDocbookPage [uri]\n\nError: " + reason;
        System.out.println(s);
        System.exit(i);
    }

    private void run(String uri) {
        this.frame = new JFrame("Show Sample DocBook XML Rendered with Pure CSS");
        this.frame.setDefaultCloseOperation(3);
        XHTMLPanel panel = new XHTMLPanel();
        panel.getSharedContext().setUserAgentCallback((UserAgentCallback)new ResourceLoadingUserAgent());
        this.setAntiAlias(panel);
        FSScrollPane fsp = new FSScrollPane((JPanel)panel);
        this.frame.getContentPane().add((Component)fsp, "Center");
        this.frame.pack();
        this.frame.setSize(1024, 768);
        this.frame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            URL url = ShowDocBookPage.class.getResource(uri);
            String urls = url.toExternalForm();
            XRLog.general((String)("Loading URI: " + urls));
            panel.setDocument(urls);
            this.showAboutDialog();
        });
    }

    private void setAntiAlias(XHTMLPanel introPanel) {
        SharedContext sharedContext = introPanel.getSharedContext();
        sharedContext.setTextRenderer((TextRenderer)new Java2DTextRenderer());
    }

    private void showAboutDialog() {
        final JDialog aboutDlg = new JDialog(this.frame);
        aboutDlg.setSize(new Dimension(500, 450));
        XHTMLPanel panel = new XHTMLPanel();
        this.setAntiAlias(panel);
        panel.setOpaque(false);
        URL url = ShowDocBookPage.class.getResource("/docbook/xhtml/intro.xhtml");
        panel.setDocument(url.toExternalForm());
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)panel, "Center");
        JButton btn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutDlg.dispose();
            }
        });
        JPanel control = new JPanel(new FlowLayout(2));
        control.add(btn);
        outer.add((Component)control, "South");
        aboutDlg.getContentPane().setLayout(new BorderLayout());
        aboutDlg.getContentPane().add((Component)outer, "Center");
        aboutDlg.setTitle("About the Browser Demo");
        int xx = (this.frame.getWidth() - aboutDlg.getWidth()) / 2;
        int yy = (this.frame.getHeight() - aboutDlg.getHeight()) / 2;
        aboutDlg.setLocation(xx, yy);
        aboutDlg.setModal(true);
        SwingUtilities.invokeLater(() -> aboutDlg.setVisible(true));
        SwingUtilities.invokeLater(() -> btn.requestFocusInWindow());
    }

    private static class ResourceLoadingUserAgent
    extends NaiveUserAgent {
        private ResourceLoadingUserAgent() {
        }

        protected InputStream resolveAndOpenStream(String uri) {
            InputStream result = super.resolveAndOpenStream(uri);
            if (result == null && uri != null && uri.startsWith("file:")) {
                return ShowDocBookPage.class.getResourceAsStream(uri.substring("file:".length()));
            }
            return result;
        }
    }
}

