/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PlainTextXMLReader
implements XMLReader {
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private final BufferedReader text;

    public PlainTextXMLReader(InputStream is) {
        this.text = new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public boolean getFeature(String s) throws SAXNotRecognizedException {
        if (s.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (s.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(s);
    }

    @Override
    public void setFeature(String s, boolean b) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (s.equals("http://xml.org/sax/features/namespaces")) {
            if (!b) {
                throw new SAXNotSupportedException(s);
            }
            return;
        }
        if (s.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (b) {
                throw new SAXNotSupportedException(s);
            }
            return;
        }
        throw new SAXNotRecognizedException(s);
    }

    @Override
    public Object getProperty(String s) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException(s);
    }

    @Override
    public void setProperty(String s, Object o) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException(s);
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        String line;
        this.contentHandler.startDocument();
        this.contentHandler.startElement("http://www.w3.org/1999/xhtml", "pre", "pre", new AttributesImpl());
        while ((line = this.text.readLine()) != null) {
            char[] chars = (line + "\n").toCharArray();
            this.contentHandler.characters(chars, 0, chars.length);
            if (line != null) continue;
        }
        this.contentHandler.endElement("http://www.w3.org/1999/xhtml", "pre", "pre");
        this.contentHandler.endDocument();
    }

    @Override
    public void parse(String s) throws SAXException {
        throw new SAXNotRecognizedException(s);
    }
}

