/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.xhtmlrenderer.pdf.ITextFontResolver;

public class ListFontFamilyNames {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Need path to font files (directory or file name)");
            System.exit(1);
        }
        File fod = new File(args[0]);
        ArrayList<File> fontFiles = new ArrayList<File>();
        if (fod.isDirectory()) {
            fontFiles.addAll(Arrays.asList(Objects.requireNonNull(fod.listFiles((file, s) -> s.endsWith(".ttf")))));
        } else {
            fontFiles.add(fod);
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (File f : fontFiles) {
            Font awtFont;
            try {
                awtFont = Font.createFont(0, f);
            }
            catch (FontFormatException | IOException e) {
                throw new IllegalStateException("Failed to load font from " + f + ": " + e.getMessage(), e);
            }
            try {
                Set set = ITextFontResolver.getDistinctFontFamilyNames((String)f.getAbsolutePath(), (String)"Identity-H", (boolean)true);
                System.out.println("Font located at " + f.getPath() + "\n  family name (reported by AWT): " + awtFont.getFamily() + "\n  family name (reported by iText): " + (String)set.iterator().next() + "\n");
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("not a valid TTF or OTF file.")) {
                    errors.add(e.getMessage());
                    continue;
                }
                if (e.getMessage().contains("Table 'OS/2' does not exist")) {
                    errors.add(e.getMessage());
                    continue;
                }
                if (e.getMessage().contains("licensing restrictions.")) {
                    errors.add(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        if (errors.size() > 0) {
            if (args.length == 2 && args[1].equals("-e")) {
                System.err.println("Errors were reported on reading some font files.");
                for (String error : errors) {
                    System.err.println(error);
                }
            } else {
                System.err.println("Errors were reported on reading some font files. Pass -e as argument to show them, and re-run.");
            }
        }
    }
}

