/*
 * Decompiled with CFR 0.152.
 */
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.resource.XMLResource;
import org.xml.sax.InputSource;

public class PDFRender {
    public static void main(String[] args) throws IOException, DocumentException {
        File f;
        String url;
        if (args.length != 2) {
            System.err.println("Usage: ... [url] [pdf]");
            System.exit(1);
        }
        if ((url = args[0]).indexOf("://") == -1 && (f = new File(url)).exists()) {
            url = f.toURI().toURL().toString();
        }
        PDFRender.createPDF(url, args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPDF(String url, String pdf) throws IOException, DocumentException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(pdf);
            ITextRenderer renderer = new ITextRenderer();
            ResourceLoaderUserAgent callback = new ResourceLoaderUserAgent(renderer.getOutputDevice());
            callback.setSharedContext(renderer.getSharedContext());
            renderer.getSharedContext().setUserAgentCallback((UserAgentCallback)callback);
            Document doc = XMLResource.load((InputSource)new InputSource(url)).getDocument();
            renderer.setDocument(doc, url);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
            os = null;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class ResourceLoaderUserAgent
    extends ITextUserAgent {
        private ResourceLoaderUserAgent(ITextOutputDevice outputDevice) {
            super(outputDevice);
        }

        protected InputStream resolveAndOpenStream(String uri) {
            InputStream is = super.resolveAndOpenStream(uri);
            System.out.println("IN resolveAndOpenStream() " + uri);
            return is;
        }
    }
}

