/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class BrowserStatus
extends JPanel {
    public final JLabel text = new JLabel("Status");
    public final JLabel memory = new JLabel("? MB / ? MB");

    public BrowserStatus() {
        this.createLayout();
        this.createEvents();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", this.text);
        this.add("East", this.memory);
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 4, 3, 4);
    }

    private void createEvents() {
        new Thread(() -> {
            try {
                while (true) {
                    Runtime rt = Runtime.getRuntime();
                    long used = rt.totalMemory() - rt.freeMemory();
                    long total = rt.totalMemory();
                    String text = (used /= 0x100000L) + "M / " + (total /= 0x100000L) + "M";
                    SwingUtilities.invokeLater(() -> this.memory.setText(text));
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
        }).start();
    }
}

