/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xhtmlrenderer.demo.browser.BrowserPanelListener;
import org.xhtmlrenderer.demo.browser.BrowserStartup;
import org.xhtmlrenderer.demo.browser.BrowserStatus;
import org.xhtmlrenderer.demo.browser.DemoMarker;
import org.xhtmlrenderer.demo.browser.PanelManager;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.PDFCreationListener;
import org.xhtmlrenderer.pdf.util.XHtmlMetaToPdfInfoAdapter;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;
import org.xml.sax.SAXException;

public final class BrowserPanel
extends JPanel
implements DocumentListener {
    private static final Logger log = LoggerFactory.getLogger(BrowserPanel.class);
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger("app.browser");
    private static final int maxLineLength = 80;
    private final JButton forward;
    private final JButton backward;
    private final JButton reload;
    private final JButton goHome;
    final JTextField url;
    final BrowserStatus status;
    public final ScalableXHTMLPanel view;
    private final JScrollPane scroll;
    private final BrowserStartup root;
    private final BrowserPanelListener listener;
    private final JButton print_preview;
    private final PanelManager manager;
    private final JButton goToPage;
    final JToolBar toolbar;

    public BrowserPanel(BrowserStartup root, BrowserPanelListener listener) {
        this.root = root;
        this.listener = listener;
        this.forward = new JButton();
        this.backward = new JButton();
        this.reload = new JButton();
        this.goToPage = new JButton();
        this.goHome = new JButton();
        this.url = new JTextField();
        this.url.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                BrowserPanel.this.url.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                BrowserPanel.this.url.select(0, 0);
            }
        });
        this.manager = new PanelManager();
        this.view = new ScalableXHTMLPanel((UserAgentCallback)this.manager);
        this.manager.setRepaintListener((RepaintListener)this.view);
        ImageResourceLoader irl = new ImageResourceLoader((RepaintListener)this.view);
        this.manager.setImageResourceLoader(irl);
        this.view.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new SwingReplacedElementFactory((RepaintListener)this.view, irl));
        this.view.addDocumentListener((DocumentListener)this.manager);
        this.view.setCenteredPagedView(true);
        this.view.setBackground(Color.LIGHT_GRAY);
        this.scroll = new FSScrollPane((JPanel)this.view);
        this.print_preview = new JButton();
        this.loadCustomFonts();
        this.status = new BrowserStatus();
        this.toolbar = this.initToolbar();
        int text_width = 200;
        this.view.setPreferredSize(new Dimension(text_width, text_width));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        this.createActions();
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.add(this.backward);
        toolbar.add(this.forward);
        toolbar.add(this.reload);
        toolbar.add(this.goHome);
        toolbar.add(this.url);
        toolbar.add(this.goToPage);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private void loadCustomFonts() {
        SharedContext rc = this.view.getSharedContext();
        try {
            rc.setFontMapping("Fuzz", Font.createFont(0, Objects.requireNonNull(DemoMarker.class.getResourceAsStream("/demos/fonts/fuzz.ttf"))));
        }
        catch (Exception ex) {
            Uu.p((Exception)ex);
        }
    }

    private void createActions() {
        this.backward.setAction(this.root.actions.backward);
        this.backward.setText("");
        this.forward.setAction(this.root.actions.forward);
        this.forward.setText("");
        this.reload.setAction(this.root.actions.reload);
        this.reload.setText("");
        this.goHome.setAction(this.root.actions.goHome);
        this.goHome.setText("");
        this.print_preview.setAction(this.root.actions.print_preview);
        this.print_preview.setText("");
        this.url.setAction(this.root.actions.load);
        this.goToPage.setAction(this.root.actions.goToPage);
        this.updateButtons();
    }

    public void goForward() {
        String uri = this.manager.getForward();
        this.view.setDocument(uri);
        this.updateButtons();
    }

    public void goBack() {
        String uri = this.manager.getBack();
        this.view.setDocument(uri);
        this.updateButtons();
    }

    public void reloadPage() {
        logger.info("Reloading Page: ");
        if (this.manager.getBaseURL() != null) {
            this.loadPage(this.manager.getBaseURL());
        }
    }

    public void loadPage(String url_text) {
        try {
            logger.info("Loading Page: " + url_text);
            this.view.setCursor(new Cursor(3));
            this.view.setDocument(url_text);
            this.view.addDocumentListener((DocumentListener)this);
            this.updateButtons();
            this.setStatus("Successfully loaded: " + url_text);
            if (this.listener != null) {
                this.listener.pageLoadSuccess(url_text, this.view.getDocumentTitle());
            }
        }
        catch (XRRuntimeException ex) {
            XRLog.general((Level)Level.SEVERE, (String)"Runtime exception", (Throwable)ex);
            this.setStatus("Can't load document");
            this.handlePageLoadFailed(url_text, ex);
        }
        catch (Exception ex) {
            XRLog.general((Level)Level.SEVERE, (String)"Could not load page for display.", (Throwable)ex);
            log.error("Failed to load page for display", (Throwable)ex);
        }
    }

    public void exportToPdf(String path) throws IOException, ParserConfigurationException, SAXException {
        if (this.manager.getBaseURL() != null) {
            this.setStatus("Exporting to " + path + "...");
            try (OutputStream os = Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
                ITextRenderer renderer = new ITextRenderer();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(this.manager.getBaseURL());
                XHtmlMetaToPdfInfoAdapter pdfCreationListener = new XHtmlMetaToPdfInfoAdapter(doc);
                renderer.setListener((PDFCreationListener)pdfCreationListener);
                renderer.createPDF(doc, os);
                this.setStatus("Done export.");
            }
        }
    }

    private void handlePageLoadFailed(String url_text, XRRuntimeException ex) {
        String rootCause = this.getRootCause((Exception)((Object)ex));
        String msg = GeneralUtil.escapeHTML((String)this.addLineBreaks(rootCause));
        String notFound = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \" -//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n<body>\n<h1>Document can't be loaded</h1>\n<p>Could not load the page at \n<pre>" + GeneralUtil.escapeHTML((String)url_text) + "</pre>\n</p>\n<p>The page failed to load; the error was </p>\n<pre>" + msg + "</pre>\n</body>\n</html>";
        XMLResource xr = XMLResource.load((Reader)new StringReader(notFound));
        SwingUtilities.invokeLater(() -> this.root.panel.view.setDocument(xr.getDocument(), null));
    }

    private String addLineBreaks(String _text) {
        StringBuilder broken = new StringBuilder(_text.length() + 10);
        boolean needBreak = false;
        for (int i = 0; i < _text.length(); ++i) {
            if (i > 0 && i % 80 == 0) {
                needBreak = true;
            }
            char c = _text.charAt(i);
            if (needBreak && Character.isWhitespace(c)) {
                System.out.println("Breaking: " + String.valueOf(broken));
                needBreak = false;
                broken.append('\n');
                continue;
            }
            broken.append(c);
        }
        System.out.println("Broken! " + String.valueOf(broken));
        return broken.toString();
    }

    private String getRootCause(Exception ex) {
        Throwable cause;
        for (cause = ex; cause != null; cause = cause.getCause()) {
        }
        return cause == null ? ex.getMessage() : cause.getMessage();
    }

    public void documentStarted() {
    }

    public void documentLoaded() {
        this.view.setCursor(new Cursor(0));
    }

    public void setStatus(String txt) {
        this.status.text.setText(txt);
    }

    protected void updateButtons() {
        this.root.actions.backward.setEnabled(this.manager.hasBack());
        this.root.actions.forward.setEnabled(this.manager.hasForward());
        this.url.setText(this.manager.getBaseURL());
    }

    public void onLayoutException(Throwable t) {
        log.error(t.toString(), t);
    }

    public void onRenderException(Throwable t) {
        log.error(t.toString(), t);
    }
}

