/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.demo.browser.BrowserActions;
import org.xhtmlrenderer.demo.browser.BrowserMenuBar;
import org.xhtmlrenderer.demo.browser.BrowserPanel;
import org.xhtmlrenderer.demo.browser.BrowserPanelListener;
import org.xhtmlrenderer.demo.browser.ValidationHandler;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.XRLog;

public class BrowserStartup {
    private static final Logger log = LoggerFactory.getLogger(BrowserStartup.class);
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger("app.browser");
    public final BrowserPanel panel;
    final JFrame frame;
    @Nullable JFrame validation_console = null;
    final BrowserActions actions;
    private final String startPage;
    final ValidationHandler error_handler = new ValidationHandler();

    public BrowserStartup() {
        this("/demos/splash/splash.html");
    }

    public BrowserStartup(String startPage) {
        logger.info("starting up");
        URL url = Objects.requireNonNull(this.getClass().getResource(startPage), () -> "Start page not found in classpath: " + startPage);
        this.startPage = url.toExternalForm();
        BrowserStartup.setLookAndFeel();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        this.frame = frame;
        logger.info("creating UI");
        this.actions = new BrowserActions(this, startPage);
        this.panel = new BrowserPanel(this, new FrameBrowserPanelListener());
        frame.setJMenuBar(new BrowserMenuBar(this));
        frame.getContentPane().add((Component)this.panel.toolbar, "First");
        frame.getContentPane().add((Component)this.panel, "Center");
        this.panel.setBorder(new EtchedBorder(1));
        frame.getContentPane().add((Component)this.panel.status, "Last");
        frame.pack();
        frame.setSize(1024, 768);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            BrowserStartup bs = new BrowserStartup();
            bs.launch();
        });
    }

    public void launch() {
        try {
            this.panel.loadPage(this.startPage);
            this.frame.setVisible(true);
        }
        catch (Exception ex) {
            XRLog.general((Level)Level.SEVERE, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void setLookAndFeel() {
        if (GeneralUtil.isMacOSX()) {
            BrowserStartup.setLookAndFeel_mac();
        } else {
            BrowserStartup.setLookAndFeel_nonMac();
        }
    }

    private static void setLookAndFeel_mac() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FS Browser");
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "error initializing the mac properties", e);
            }
            catch (Exception ex2) {
                log.error("error writing to the log file", (Throwable)ex2);
            }
        }
    }

    private static void setLookAndFeel_nonMac() {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (Throwable e) {
            log.debug("Failed to use JGoodies look and feel", e);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable ex) {
                log.error("Failed to use system look and feel", ex);
            }
        }
    }

    class FrameBrowserPanelListener
    implements BrowserPanelListener {
        FrameBrowserPanelListener() {
        }

        @Override
        public void pageLoadSuccess(String url, String title) {
            BrowserStartup.this.frame.setTitle(title + (!title.isEmpty() ? " - " : "") + "Flying Saucer");
        }
    }
}

