/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.swing.UriResolver;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.StreamResource;

@ParametersAreNonnullByDefault
public class DelegatingUserAgent
implements UserAgentCallback,
DocumentListener {
    private final UriResolver _uriResolver = new UriResolver();
    private ImageResourceLoader _imageResourceLoader;

    public void setImageResourceLoader(ImageResourceLoader loader) {
        this._imageResourceLoader = loader;
    }

    public void shrinkImageCache() {
        this._imageResourceLoader.shrink();
    }

    public void clearImageCache() {
        this._imageResourceLoader.clear();
    }

    protected InputStream resolveAndOpenStream(String uri) {
        return IOUtil.openStreamAtUrl(this._uriResolver.resolve(uri));
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.resolveAndOpenStream(uri));
    }

    @Override
    public ImageResource getImageResource(String uri) {
        return this._imageResourceLoader.get(this.resolveURI(uri));
    }

    @Override
    public XMLResource getXMLResource(String uri) {
        String ruri = this._uriResolver.resolve(uri);
        StreamResource sr = new StreamResource(ruri);
        try {
            sr.connect();
            BufferedInputStream bis = sr.bufferedStream();
            XMLResource xMLResource = XMLResource.load(bis);
            sr.close();
            return xMLResource;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    @Override
    @Nullable
    @CheckReturnValue
    public byte[] getBinaryResource(String uri) {
        String ruri = this._uriResolver.resolve(uri);
        StreamResource sr = new StreamResource(ruri);
        try {
            sr.connect();
            byte[] byArray = IOUtil.readBytes(sr.bufferedStream());
            sr.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String uri) {
        this._uriResolver.setBaseUri(uri);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String resolveURI(@Nullable String uri) {
        return this._uriResolver.resolve(uri);
    }

    @Override
    public String getBaseURL() {
        return this._uriResolver.getBaseUri();
    }

    @Override
    public void documentStarted() {
        this._imageResourceLoader.stopLoading();
        this.shrinkImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }

    public void setRepaintListener(RepaintListener listener) {
    }
}

