/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.resource;

import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.resource.Resource;
import org.xml.sax.InputSource;

@ParametersAreNonnullByDefault
public abstract class AbstractResource
implements Resource {
    private final InputSource inputSource;
    private final long createTimeStamp;
    private long elapsedLoadTime;

    protected AbstractResource(@Nullable InputSource source) {
        this.inputSource = source;
        this.createTimeStamp = System.currentTimeMillis();
    }

    protected AbstractResource(@Nullable InputStream is) {
        this(is == null ? null : new InputSource(new BufferedInputStream(is)));
    }

    @Override
    @Nullable
    @CheckReturnValue
    public InputSource getResourceInputSource() {
        return this.inputSource;
    }

    @Override
    @CheckReturnValue
    public long getResourceLoadTimeStamp() {
        return this.createTimeStamp;
    }

    @CheckReturnValue
    public long getElapsedLoadTime() {
        return this.elapsedLoadTime;
    }

    void setElapsedLoadTime(long elapsedLoadTime) {
        this.elapsedLoadTime = elapsedLoadTime;
    }
}

