/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.util.Objects;
import javax.annotation.Nullable;
import org.w3c.dom.Element;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.ButtonField;
import org.xhtmlrenderer.simple.extend.form.CheckboxField;
import org.xhtmlrenderer.simple.extend.form.FileField;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.HiddenField;
import org.xhtmlrenderer.simple.extend.form.ImageField;
import org.xhtmlrenderer.simple.extend.form.PasswordField;
import org.xhtmlrenderer.simple.extend.form.RadioButtonField;
import org.xhtmlrenderer.simple.extend.form.ResetField;
import org.xhtmlrenderer.simple.extend.form.SelectField;
import org.xhtmlrenderer.simple.extend.form.SubmitField;
import org.xhtmlrenderer.simple.extend.form.TextAreaField;
import org.xhtmlrenderer.simple.extend.form.TextField;

public class FormFieldFactory {
    private FormFieldFactory() {
    }

    public static FormField create(XhtmlForm form, LayoutContext context, BlockBox box) {
        Element e = Objects.requireNonNull(box.getElement());
        String typeKey = FormFieldFactory.getTypeKey(e);
        if (typeKey == null) {
            return null;
        }
        switch (typeKey) {
            case "submit": {
                return new SubmitField(e, form, context, box);
            }
            case "reset": {
                return new ResetField(e, form, context, box);
            }
            case "button": {
                return new ButtonField(e, form, context, box);
            }
            case "image": {
                return new ImageField(e, form, context, box);
            }
            case "hidden": {
                return new HiddenField(e, form, context, box);
            }
            case "password": {
                return new PasswordField(e, form, context, box);
            }
            case "checkbox": {
                return new CheckboxField(e, form, context, box);
            }
            case "radio": {
                return new RadioButtonField(e, form, context, box);
            }
            case "file": {
                return new FileField(e, form, context, box);
            }
            case "textarea": {
                return new TextAreaField(e, form, context, box);
            }
            case "select": {
                return new SelectField(e, form, context, box);
            }
        }
        return new TextField(e, form, context, box);
    }

    @Nullable
    private static String getTypeKey(Element e) {
        switch (e.getNodeName()) {
            case "input": {
                return e.getAttribute("type");
            }
            case "textarea": {
                return "textarea";
            }
            case "select": {
                return "select";
            }
        }
        return null;
    }
}

