/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

public class ContentTypeDetectingInputStreamWrapper
extends BufferedInputStream {
    private static final byte[] MAGIC_BYTES_PDF = "%PDF".getBytes(StandardCharsets.UTF_8);
    private static final byte[] MAGIC_BYTES_XML = "<?xm".getBytes(StandardCharsets.UTF_8);
    private static final byte[] MAGIC_BYTES_SVG = "<svg".getBytes(StandardCharsets.UTF_8);
    private static final int MAX_MAGIC_BYTES = 4;
    private static final byte[] NO_DATA = new byte[0];
    private final byte[] firstBytes = ContentTypeDetectingInputStreamWrapper.readFirstBytes(this, 4);

    @CheckReturnValue
    public static @Nullable ContentTypeDetectingInputStreamWrapper detectContentType(@Nullable InputStream is) throws IOException {
        return is == null ? null : new ContentTypeDetectingInputStreamWrapper(is);
    }

    private ContentTypeDetectingInputStreamWrapper(InputStream source) throws IOException {
        super(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFirstBytes(InputStream in, int count) throws IOException {
        in.mark(count);
        try {
            byte[] buffer = new byte[count];
            int bytesRead = in.read(buffer);
            byte[] byArray = bytesRead >= count ? buffer : (bytesRead <= 0 ? NO_DATA : Arrays.copyOf(buffer, bytesRead));
            return byArray;
        }
        finally {
            in.reset();
        }
    }

    private boolean streamStartsWithMagicBytes(byte[] bytes) {
        return Arrays.equals(this.firstBytes, bytes);
    }

    public boolean isPdf() {
        return this.streamStartsWithMagicBytes(MAGIC_BYTES_PDF);
    }

    public boolean isSvg() {
        return this.streamStartsWithMagicBytes(MAGIC_BYTES_XML) || this.streamStartsWithMagicBytes(MAGIC_BYTES_SVG);
    }
}

