/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.DefaultCSSMarker;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.LoggerUtil;
import org.xhtmlrenderer.util.XRLog;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private final Properties properties;
    private Level logLevel = Level.OFF;
    private static final Configuration sInstance = new Configuration();
    private final List<LogRecord> startupLogRecords = new ArrayList<LogRecord>();
    private @Nullable java.util.logging.Logger configLogger;
    private static final String SF_FILE_NAME = "resources/conf/xhtmlrenderer.conf";

    private Configuration() {
        try {
            String val = this.getSystemProperty("show-config");
            if (val != null) {
                this.logLevel = LoggerUtil.parseLogLevel(val, Level.OFF);
            }
            this.properties = this.loadDefaultProperties();
            String sysOverrideFile = this.getSystemPropertyOverrideFileName();
            if (sysOverrideFile != null) {
                this.loadOverrideProperties(sysOverrideFile);
            } else {
                String userHomeOverrideFileName = this.getUserHomeOverrideFileName();
                if (userHomeOverrideFileName != null) {
                    this.loadOverrideProperties(userHomeOverrideFileName);
                }
            }
            this.loadSystemProperties();
            this.logAfterLoad();
        }
        catch (RuntimeException e) {
            this.handleUnexpectedExceptionOnInit(e);
            throw e;
        }
        catch (Exception e) {
            this.handleUnexpectedExceptionOnInit(e);
            throw new RuntimeException(e);
        }
    }

    private void handleUnexpectedExceptionOnInit(Exception e) {
        System.err.println("Could not initialize configuration for Flying Saucer library. Message is: " + e.getMessage());
        log.error(e.toString(), (Throwable)e);
    }

    public static void setConfigLogger(java.util.logging.Logger logger) {
        Configuration config = Configuration.instance();
        config.configLogger = logger;
        for (LogRecord lr : config.startupLogRecords) {
            logger.log(lr.getLevel(), lr.getMessage());
        }
        config.startupLogRecords.clear();
    }

    private void println(Level level, String msg) {
        if (!this.logLevel.equals(Level.OFF)) {
            if (this.configLogger == null) {
                this.startupLogRecords.add(new LogRecord(level, msg));
            } else {
                this.configLogger.log(level, msg);
            }
        }
    }

    private void info(String msg) {
        if (this.logLevel.intValue() <= Level.INFO.intValue()) {
            this.println(Level.INFO, msg);
        }
    }

    private void warning(String msg) {
        if (this.logLevel.intValue() <= Level.WARNING.intValue()) {
            this.println(Level.WARNING, msg);
        }
    }

    private void warning(String msg, Throwable th) {
        this.warning(msg);
        log.error(msg, th);
    }

    private void fine(String msg) {
        if (this.logLevel.intValue() <= Level.FINE.intValue()) {
            this.println(Level.FINE, msg);
        }
    }

    private void finer(String msg) {
        if (this.logLevel.intValue() <= Level.FINER.intValue()) {
            this.println(Level.FINER, msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    private Properties loadDefaultProperties() {
        try (InputStream readStream = GeneralUtil.openStreamFromClasspath(new DefaultCSSMarker(), SF_FILE_NAME);){
            if (readStream == null) {
                log.warn("No configuration files found in classpath using URL {}, resorting to hard-coded fallback properties.", (Object)SF_FILE_NAME);
                Properties properties2 = this.newFallbackProperties();
                return properties2;
            }
            Properties properties3 = new Properties();
            properties3.load(readStream);
            this.info("Configuration loaded from resources/conf/xhtmlrenderer.conf");
            Properties properties = properties3;
            return properties;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load properties file for configuration.", ex);
        }
    }

    private void loadOverrideProperties(String uri) {
        Properties temp;
        block18: {
            File f = new File(uri);
            temp = new Properties();
            if (f.exists()) {
                this.info("Found config override file " + f.getAbsolutePath());
                try (BufferedInputStream readStream = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
                    temp.load(readStream);
                    break block18;
                }
                catch (IOException iex) {
                    this.warning("Error while loading override properties file; skipping.", iex);
                    return;
                }
            }
            try {
                URL url = new URL(uri);
                try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
                    this.info("Found config override URI " + uri);
                    temp.load(in);
                }
            }
            catch (MalformedURLException e) {
                this.warning("URI for override properties is malformed, skipping: '%s' (caused by: %s)".formatted(uri, e));
                return;
            }
            catch (IOException e) {
                this.warning("Overridden properties could not be loaded from URI: " + uri, e);
                return;
            }
        }
        int cnt = 0;
        for (String key : Configuration.sortedKeys(this.properties)) {
            String val = temp.getProperty(key);
            if (val == null) continue;
            this.properties.setProperty(key, val);
            this.finer("  " + key + " -> " + val);
            ++cnt;
        }
        this.finer("Configuration: " + cnt + " properties overridden from secondary properties file.");
        Collection<String> allRead = Configuration.sortedKeys(temp);
        cnt = 0;
        for (String key : allRead) {
            String val = temp.getProperty(key);
            if (val == null) continue;
            this.properties.setProperty(key, val);
            this.finer("  (+)" + key + " -> " + val);
            ++cnt;
        }
        this.finer("Configuration: " + cnt + " properties added from secondary properties file.");
    }

    private @Nullable String getSystemPropertyOverrideFileName() {
        return this.getSystemProperty("xr.conf");
    }

    private @Nullable String getUserHomeOverrideFileName() {
        String confFileName = "local.xhtmlrenderer.conf";
        try {
            return Path.of(System.getProperty("user.home"), ".flyingsaucer", confFileName).toString();
        }
        catch (SecurityException e) {
            log.warn("Cannot read file '{}': {}", (Object)confFileName, (Object)e.toString());
            return null;
        }
    }

    private static Collection<String> sortedKeys(Properties properties) {
        ArrayList<String> keys = new ArrayList<String>(properties.size());
        properties.keySet().forEach(key -> keys.add((String)key));
        Collections.sort(keys);
        return keys;
    }

    private void loadSystemProperties() {
        this.fine("Overriding loaded configuration from System properties.");
        int cnt = 0;
        for (String key : Configuration.sortedKeys(this.properties)) {
            String val;
            if (!key.startsWith("xr.") || (val = this.getSystemProperty(key)) == null) continue;
            this.properties.setProperty(key, val);
            this.finer("  Overrode value for " + key);
            ++cnt;
        }
        this.fine("Configuration: " + cnt + " properties overridden from System properties.");
        try {
            Properties sysProps = System.getProperties();
            cnt = 0;
            for (String key : Configuration.sortedKeys(this.properties)) {
                if (!key.startsWith("xr.") || this.properties.containsKey(key)) continue;
                String val = sysProps.getProperty(key);
                this.properties.setProperty(key, val);
                this.finer("  (+) " + key);
                ++cnt;
            }
        }
        catch (SecurityException e) {
            log.warn("Cannot read system properties: {}", (Object)e.toString());
        }
        this.fine("Configuration: " + cnt + " FS properties added from System properties.");
    }

    private void logAfterLoad() {
        this.finer("Configuration contains " + this.properties.size() + " keys.");
        this.finer("List of configuration properties, after override:");
        for (String key : Configuration.sortedKeys(this.properties)) {
            String val = this.properties.getProperty(key);
            this.finer("  " + key + " = " + val);
        }
        this.finer("Properties list complete.");
    }

    public static @Nullable String valueFor(String key) {
        Configuration conf = Configuration.instance();
        String val = conf.properties.getProperty(key);
        if (val == null) {
            conf.warning("CONFIGURATION: no value found for key " + key);
        }
        return val;
    }

    public static int valueAsByte(String key, byte defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as a byte, but value of '" + val + "' is not a byte. Check configuration.");
            return defaultVal;
        }
    }

    public static int valueAsShort(String key, short defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Short.parseShort(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as a short, but value of '" + val + "' is not a short. Check configuration.");
            return defaultVal;
        }
    }

    public static int valueAsInt(String key, int defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as an integer, but value of '" + val + "' is not an integer. Check configuration.");
            return defaultVal;
        }
    }

    public static char valueAsChar(String key, char defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        if (val.length() > 1) {
            XRLog.exception("Property '" + key + "' was requested as a character. The value of '" + val + "' is too long to be a char. Returning only the first character.");
        }
        return val.charAt(0);
    }

    public static long valueAsLong(String key, long defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as a long, but value of '" + val + "' is not a long. Check configuration.");
            return defaultVal;
        }
    }

    public static float valueAsFloat(String key, float defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as a float, but value of '" + val + "' is not a float. Check configuration.");
            return defaultVal;
        }
    }

    public static double valueAsDouble(String key, double defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException ignore) {
            XRLog.exception("Property '" + key + "' was requested as a double, but value of '" + val + "' is not a double. Check configuration.");
            return defaultVal;
        }
    }

    public static String valueFor(String key, String defaultVal) {
        Configuration conf = Configuration.instance();
        String val = conf.properties.getProperty(key);
        String string = val = val == null ? defaultVal : val;
        if (val == null) {
            conf.warning("CONFIGURATION: no value found for key " + key + " and no default given.");
        }
        return val;
    }

    public static Iterator<String> keysByPrefix(String prefix) {
        Configuration conf = Configuration.instance();
        return Configuration.sortedKeys(conf.properties).stream().filter(key -> key.startsWith(prefix)).iterator();
    }

    public static boolean isTrue(String key, boolean defaultVal) {
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultVal;
        }
        if (!"true|false".contains(val)) {
            XRLog.exception("Property '" + key + "' was requested as a boolean, but value of '" + val + "' is not a boolean. Check configuration.");
            return defaultVal;
        }
        return Boolean.parseBoolean(val);
    }

    public static boolean isFalse(String key, boolean defaultVal) {
        return !Configuration.isTrue(key, defaultVal);
    }

    private static Configuration instance() {
        return sInstance;
    }

    public static Object valueFromClassConstant(String key, Object defaultValue) {
        Object constantValue;
        Class<?> klass;
        String constant;
        String className;
        Configuration conf = Configuration.instance();
        String val = Configuration.valueFor(key);
        if (val == null) {
            return defaultValue;
        }
        int idx = val.lastIndexOf(46);
        try {
            className = val.substring(0, idx);
            constant = val.substring(idx + 1);
        }
        catch (IndexOutOfBoundsException ignore) {
            conf.warning("Property key " + key + " for object value constant is not properly formatted; should be FQN<dot>constant, is " + val);
            return defaultValue;
        }
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            conf.warning("Property for object value constant " + key + " is not a FQN: " + className + ", caused by: " + String.valueOf(e));
            return defaultValue;
        }
        try {
            Field fld = klass.getDeclaredField(constant);
            try {
                constantValue = fld.get(klass);
            }
            catch (IllegalAccessException e) {
                conf.warning("Property for object value constant " + key + ", field is not public: " + className + "." + constant + ", caused by: " + String.valueOf(e));
                return defaultValue;
            }
        }
        catch (NoSuchFieldException e) {
            conf.warning("Property for object value constant " + key + " is not a FQN: " + className + ", caused by: " + String.valueOf(e));
            return defaultValue;
        }
        return constantValue;
    }

    @CheckReturnValue
    private Properties newFallbackProperties() {
        Properties props = new Properties();
        props.setProperty("xr.css.user-agent-default-css", "/resources/css/");
        props.setProperty("xr.test.files.hamlet", "/demos/browser/xhtml/hamlet.xhtml");
        props.setProperty("xr.simple-log-format", "{1} {2}:: {5}");
        props.setProperty("xr.simple-log-format-throwable", "{1} {2}:: {5}");
        props.setProperty("xr.test-config-byte", "8");
        props.setProperty("xr.test-config-short", "16");
        props.setProperty("xr.test-config-int", "100");
        props.setProperty("xr.test-config-long", "2000");
        props.setProperty("xr.test-config-float", "3000.25F");
        props.setProperty("xr.test-config-double", "4000.50D");
        props.setProperty("xr.test-config-boolean", "true");
        props.setProperty("xr.util-logging.loggingEnabled", "false");
        props.setProperty("xr.util-logging.handlers", "java.util.logging.ConsoleHandler");
        props.setProperty("xr.util-logging.use-parent-handler", "false");
        props.setProperty("xr.util-logging.java.util.logging.ConsoleHandler.level", "INFO");
        props.setProperty("xr.util-logging.java.util.logging.ConsoleHandler.formatter", "org.xhtmlrenderer.util.XRSimpleLogFormatter");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.config.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.exception.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.general.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.init.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.load.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.load.xml-entities.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.match.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.cascade.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.css-parse.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.layout.level", "ALL");
        props.setProperty("xr.util-logging.org.xhtmlrenderer.render.level", "ALL");
        props.setProperty("xr.load.xml-reader", "default");
        props.setProperty("xr.load.configure-features", "false");
        props.setProperty("xr.load.validation", "false");
        props.setProperty("xr.load.string-interning", "false");
        props.setProperty("xr.load.namespaces", "false");
        props.setProperty("xr.load.namespace-prefixes", "false");
        props.setProperty("xr.layout.whitespace.experimental", "true");
        props.setProperty("xr.layout.bad-sizing-hack", "false");
        props.setProperty("xr.renderer.viewport-repaint", "true");
        props.setProperty("xr.renderer.draw.backgrounds", "true");
        props.setProperty("xr.renderer.draw.borders", "true");
        props.setProperty("xr.renderer.debug.box-outlines", "false");
        props.setProperty("xr.renderer.replace-missing-characters", "false");
        props.setProperty("xr.renderer.missing-character-replacement", "false");
        props.setProperty("xr.text.scale", "1.0");
        props.setProperty("xr.text.aa-smoothing-level", "1");
        props.setProperty("xr.text.aa-fontsize-threshhold", "0");
        props.setProperty("xr.text.aa-rendering-hint", "RenderingHints.VALUE_TEXT_ANTIALIAS_HGRB");
        props.setProperty("xr.cache.stylesheets", "false");
        props.setProperty("xr.incremental.enabled", "false");
        props.setProperty("xr.incremental.lazyimage", "false");
        props.setProperty("xr.incremental.debug.layoutdelay", "0");
        props.setProperty("xr.incremental.repaint.print-timing", "false");
        props.setProperty("xr.use.threads", "false");
        props.setProperty("xr.use.listeners", "true");
        props.setProperty("xr.image.buffered", "false");
        props.setProperty("xr.image.scale", "LOW");
        props.setProperty("xr.image.render-quality", "java.awt.RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR");
        return props;
    }

    private @Nullable String getSystemProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            log.warn("Cannot read system property '{}': {}", (Object)name, (Object)e.toString());
            return null;
        }
    }
}

