/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextFieldUI;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.InputField;

class TextField
extends InputField<JTextField> {
    TextField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        super(e, form, context, box);
    }

    @Override
    public JTextField create() {
        TextFieldJTextField textField = new TextFieldJTextField();
        this.prepareTextField(textField);
        this.applyComponentStyle(textField);
        return textField;
    }

    @Override
    protected void applyComponentStyle(JComponent component) {
        FSDerivedValue heightValue;
        super.applyComponentStyle(component);
        JTextField field = (JTextField)this.component();
        CalculatedStyle style = this.getBox().getStyle();
        RectPropertySet padding = style.getCachedPadding();
        Insets margin = style.padding().withDefaults(new Insets(2, 3, 2, 3));
        if (style.disableOSBorder()) {
            BasicTextFieldUI ui = new BasicTextFieldUI();
            field.setUI(ui);
            Border fieldBorder = BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
            field.setBorder(fieldBorder);
        } else {
            field.setMargin(margin);
        }
        padding.reset();
        FSDerivedValue widthValue = style.valueByName(CSSName.WIDTH);
        if (widthValue instanceof LengthValue) {
            this.intrinsicWidth = this.getBox().getContentWidth() + margin.left + margin.right;
        }
        if ((heightValue = style.valueByName(CSSName.HEIGHT)) instanceof LengthValue) {
            this.intrinsicHeight = this.getBox().getHeight() + margin.top + margin.bottom;
        }
    }

    @Override
    protected void applyOriginalState() {
        JTextField textField = (JTextField)this.component();
        textField.setText(this.getOriginalState().getValue());
        textField.setCaretPosition(0);
    }

    @Override
    protected String[] getFieldValues() {
        JTextField textField = (JTextField)this.component();
        return new String[]{textField.getText()};
    }

    private static class TextFieldJTextField
    extends JTextField {
        private int columnWidth = 0;

        private TextFieldJTextField() {
        }

        @Override
        protected int getColumnWidth() {
            if (this.columnWidth == 0) {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                this.columnWidth = metrics.charWidth('o');
            }
            return this.columnWidth;
        }
    }
}

