/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.simple.extend.StyleBuilder;
import org.xhtmlrenderer.simple.extend.XhtmlCssOnlyNamespaceHandler;

public class XhtmlNamespaceHandler
extends XhtmlCssOnlyNamespaceHandler {
    private static final Pattern RE_MANGLED_COLOR = Pattern.compile("[0-9a-f]{6}");

    @Override
    @CheckReturnValue
    public boolean isImageElement(Element e) {
        return e.getNodeName().equalsIgnoreCase("img");
    }

    @Override
    @CheckReturnValue
    public boolean isFormElement(Element e) {
        return e.getNodeName().equalsIgnoreCase("form");
    }

    @Override
    @CheckReturnValue
    public String getImageSourceURI(Element e) {
        return e.getAttribute("src");
    }

    @Override
    @CheckReturnValue
    public String getNonCssStyling(Element e) {
        return switch (e.getNodeName()) {
            case "table" -> this.applyTableStyles(e);
            case "td", "th" -> this.applyTableCellStyles(e);
            case "tr" -> this.applyTableRowStyles(e);
            case "img" -> this.applyImgStyles(e);
            case "p", "div" -> this.applyBlockAlign(e);
            default -> "";
        };
    }

    private String applyBlockAlign(Element e) {
        String s;
        return switch (s = e.getAttribute("align").trim().toLowerCase(Locale.ROOT)) {
            case "left", "right", "center", "justify" -> "text-align: " + s + ";";
            default -> "";
        };
    }

    private String applyImgStyles(Element e) {
        StyleBuilder style = new StyleBuilder();
        style.applyFloatingAlign(e);
        return style.toString();
    }

    private String applyTableCellStyles(Element e) {
        StyleBuilder style = new StyleBuilder();
        Element table = this.findTable(e);
        if (table != null) {
            style.appendLength(table, "cellpadding", "padding: ");
            String s = this.getAttribute(table, "border");
            if (s != null && !s.equals("0")) {
                style.appendRawStyle("border: 1px outset black;");
            }
        }
        style.appendWidth(e);
        style.appendHeight(e);
        style.applyTableContentAlign(e);
        this.appendBackgroundColor(e, style);
        this.appendBackgroundImage(e, style);
        return style.toString();
    }

    private void appendBackgroundColor(Element e, StyleBuilder style) {
        String s = e.getAttribute("bgcolor").trim();
        if (!s.isEmpty()) {
            Object color = this.looksLikeAMangledColor(s) ? "#" + s : s;
            style.appendStyle("background-color: ", (String)color);
        }
    }

    private void appendBackgroundImage(Element e, StyleBuilder style) {
        style.appendUrl(e, "background", "background-image: ");
    }

    private String applyTableStyles(Element e) {
        StyleBuilder style = new StyleBuilder();
        style.appendLength(e, "width", "width: ");
        style.appendLength(e, "border", "border: ", " inset black;");
        style.appendLength(e, "cellspacing", "border-collapse: separate; border-spacing: ");
        this.appendBackgroundColor(e, style);
        this.appendBackgroundImage(e, style);
        style.applyFloatingAlign(e);
        return style.toString();
    }

    private String applyTableRowStyles(Element e) {
        StyleBuilder style = new StyleBuilder();
        style.applyTableContentAlign(e);
        return style.toString();
    }

    boolean looksLikeAMangledColor(String s) {
        return RE_MANGLED_COLOR.matcher(s).matches();
    }

    @Nullable Element findTable(Node cell) {
        return this.ancestor(cell, "table", 5);
    }

    @Nullable Element ancestor(Node element, String tagName, int maxDepth) {
        Node parent = element.getParentNode();
        if (parent == null || maxDepth <= 0) {
            return null;
        }
        return parent.getNodeType() == 1 && parent.getNodeName().equals(tagName) ? (Element)parent : this.ancestor(parent, tagName, maxDepth - 1);
    }
}

