/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.util.Locale;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

class StyleBuilder {
    private static final Pattern RE_INTEGER = Pattern.compile("\\d+");
    private final StringBuilder style = new StringBuilder();

    StyleBuilder() {
    }

    void append(Element e, String attributeName, String styleName) {
        String attributeValue = e.getAttribute(attributeName).trim();
        if (!attributeValue.isEmpty()) {
            this.appendStyle(styleName, attributeValue);
        }
    }

    void appendUrl(Element e, String attributeName, String styleName) {
        String attributeValue = e.getAttribute(attributeName).trim();
        if (!attributeValue.isEmpty()) {
            this.appendStyle(styleName, "url(" + attributeValue + ")");
        }
    }

    void appendLength(Element e, String attributeName, String styleName) {
        this.appendLength(e, attributeName, styleName, ";");
    }

    void appendLength(Element e, String attributeName, String styleName, String suffix) {
        String attributeValue = e.getAttribute(attributeName).trim();
        if (!attributeValue.isEmpty()) {
            this.appendStyle(styleName, this.convertToLength(attributeValue), suffix);
        }
    }

    void appendStyle(String styleName, String attributeValue) {
        this.appendStyle(styleName, attributeValue, ";");
    }

    void appendStyle(String styleName, String attributeValue, String suffix) {
        this.style.append(styleName);
        this.style.append(attributeValue.toLowerCase(Locale.ROOT));
        this.style.append(suffix);
    }

    void appendWidth(Element e) {
        this.appendLength(e, "width", "width: ");
    }

    void appendHeight(Element e) {
        this.appendLength(e, "height", "height: ");
    }

    String convertToLength(String value) {
        return this.isInteger(value) ? value + "px" : value;
    }

    boolean isInteger(String value) {
        return RE_INTEGER.matcher(value).matches();
    }

    void appendRawStyle(String cssStyle) {
        this.style.append(cssStyle);
    }

    void applyTableContentAlign(Element e) {
        this.append(e, "align", "text-align: ");
        this.append(e, "valign", "vertical-align: ");
    }

    void applyFloatingAlign(Element e) {
        String s;
        switch (s = e.getAttribute("align").trim().toLowerCase(Locale.ROOT)) {
            case "": {
                break;
            }
            case "left": 
            case "right": {
                this.appendStyle("float: ", s);
                break;
            }
            case "center": {
                this.appendRawStyle("margin-left: auto; margin-right: auto;");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown align attribute: '%s'".formatted(s));
            }
        }
    }

    public String toString() {
        return this.style.toString();
    }
}

