/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.layout.CounterFunction;
import org.xhtmlrenderer.layout.CssFunction;

class CountersFunction
implements CssFunction {
    private final IdentValue _listStyleType;
    private final List<Integer> _counterValues;
    private final String _separator;

    CountersFunction(List<Integer> counterValues, String separator, IdentValue listStyleType) {
        this._listStyleType = listStyleType;
        this._counterValues = counterValues;
        this._separator = separator;
    }

    @Override
    @CheckReturnValue
    public String evaluate() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> i = this._counterValues.iterator();
        while (i.hasNext()) {
            Integer value = i.next();
            sb.append(CounterFunction.createCounterText(this._listStyleType, value));
            if (!i.hasNext()) continue;
            sb.append(this._separator);
        }
        return sb.toString();
    }
}

