/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Locale;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.layout.CssFunction;

public class CounterFunction
implements CssFunction {
    private static final String GREEK_UPPER_LETTERS = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static final String GREEK_LOWER_LETTERS = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private final IdentValue _listStyleType;
    private final int _counterValue;

    CounterFunction(int counterValue, IdentValue listStyleType) {
        this._counterValue = counterValue;
        this._listStyleType = listStyleType;
    }

    @Override
    @CheckReturnValue
    public String evaluate() {
        return CounterFunction.createCounterText(this._listStyleType, this._counterValue);
    }

    public static String createCounterText(IdentValue listStyle, int listCounter) {
        if (listStyle == IdentValue.LOWER_LATIN || listStyle == IdentValue.LOWER_ALPHA) {
            return CounterFunction.toLatin(listCounter - 1).toLowerCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.UPPER_LATIN || listStyle == IdentValue.UPPER_ALPHA) {
            return CounterFunction.toLatin(listCounter - 1).toUpperCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.LOWER_ROMAN) {
            return CounterFunction.toRoman(listCounter).toLowerCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.LOWER_GREEK) {
            return CounterFunction.toGreekLower(listCounter - 1);
        }
        if (listStyle == IdentValue.UPPER_GREEK) {
            return CounterFunction.toGreekUpper(listCounter - 1);
        }
        if (listStyle == IdentValue.UPPER_ROMAN) {
            return CounterFunction.toRoman(listCounter).toUpperCase(Locale.ROOT);
        }
        if (listStyle == IdentValue.DECIMAL_LEADING_ZERO) {
            return (listCounter >= 10 ? "" : "0") + listCounter;
        }
        return Integer.toString(listCounter);
    }

    private static String toLatin(int zeroBasedIndex) {
        return zeroBasedIndex < 0 ? "" : CounterFunction.toLatin(zeroBasedIndex / 26 - 1) + (char)(65 + zeroBasedIndex % 26);
    }

    private static String toGreekUpper(int zeroBasedIndex) {
        return zeroBasedIndex < 0 ? "" : CounterFunction.toGreekUpper(zeroBasedIndex / 24 - 1) + GREEK_UPPER_LETTERS.charAt(zeroBasedIndex % 24);
    }

    private static String toGreekLower(int zeroBasedIndex) {
        return zeroBasedIndex < 0 ? "" : CounterFunction.toGreekLower(zeroBasedIndex / 24 - 1) + GREEK_LOWER_LETTERS.charAt(zeroBasedIndex % 24);
    }

    private static String toRoman(int val) {
        int[] ints = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] nums = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ints.length; ++i) {
            int count = val / ints[i];
            sb.append(nums[i].repeat(Math.max(0, count)));
            val -= ints[i] * count;
        }
        return sb.toString();
    }
}

