/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.debug;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Visualize {
    private static double t(double value, int min, int zoom, int border) {
        return (value - (double)min) * (double)zoom + (double)border;
    }

    public static BufferedImage shape(Shape shape, int zoom, int pointSize) {
        double cy;
        double cx;
        double y;
        double x;
        int c;
        PathIterator it = shape.getPathIterator(null);
        ArrayList<Double> real = new ArrayList<Double>();
        ArrayList<Double> control = new ArrayList<Double>();
        while (!it.isDone()) {
            double[] a = new double[6];
            int tpe = it.currentSegment(a);
            switch (tpe) {
                case 0: 
                case 1: {
                    real.add(a[0]);
                    real.add(a[1]);
                    break;
                }
                case 2: {
                    control.add(a[0]);
                    control.add(a[1]);
                    real.add(a[2]);
                    real.add(a[3]);
                }
                case 3: {
                    control.add(a[0]);
                    control.add(a[1]);
                    control.add(a[2]);
                    control.add(a[3]);
                    real.add(a[4]);
                    real.add(a[5]);
                }
            }
            it.next();
        }
        ArrayList<Double> all = new ArrayList<Double>(real);
        all.addAll(control);
        double minXF = (Double)all.get(0);
        double minYF = (Double)all.get(1);
        double maxXF = minXF;
        double maxYF = minYF;
        for (int i = 0; i < all.size(); i += 2) {
            double x2 = (Double)all.get(i);
            double y2 = (Double)all.get(i + 1);
            if (x2 < minXF) {
                minXF = x2;
            }
            if (x2 > maxXF) {
                maxXF = x2;
            }
            if (y2 < minYF) {
                minYF = y2;
            }
            if (!(y2 > maxYF)) continue;
            maxYF = y2;
        }
        int minX = (int)Math.floor(minXF);
        int maxX = (int)Math.ceil(maxXF);
        int minY = (int)Math.floor(minYF);
        int maxY = (int)Math.ceil(maxYF);
        int border = zoom * 2 + 5;
        int width = (maxX - minX) * zoom + border * 2;
        int height = (maxY - minY) * zoom + border * 2;
        BufferedImage bim = new BufferedImage(width, height, 1);
        Graphics2D g2d = bim.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        AffineTransform saveAT = g2d.getTransform();
        g2d.translate(border, border);
        g2d.scale(zoom, zoom);
        g2d.translate(-minX, -minY);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(shape);
        g2d.setTransform(saveAT);
        g2d.setColor(Color.GREEN);
        for (int x3 = 0; x3 <= maxX - minX; ++x3) {
            int xx = x3 * zoom + border;
            g2d.drawLine(xx, border, xx, height - border);
        }
        for (int y3 = 0; y3 <= maxY - minY; ++y3) {
            int yy = y3 * zoom + border;
            g2d.drawLine(border, yy, width - border, yy);
        }
        int halfPoint = pointSize / 2;
        g2d.setColor(Color.RED);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (c = 0; c < control.size(); c += 2) {
            x = (Double)control.get(c);
            y = (Double)control.get(c + 1);
            cx = Visualize.t(x, minX, zoom, border);
            cy = Visualize.t(y, minY, zoom, border);
            g2d.fillRect((int)cx - halfPoint, (int)cy - halfPoint, pointSize, pointSize);
            g2d.drawString(String.format("%3$d: %1$.3f, %2$.3f", x, y, c / 2), (int)cx, (int)cy + pointSize + 32);
        }
        g2d.setColor(Color.BLUE);
        for (c = 0; c < real.size(); c += 2) {
            x = (Double)real.get(c);
            y = (Double)real.get(c + 1);
            cx = Visualize.t(x, minX, zoom, border);
            cy = Visualize.t(y, minY, zoom, border);
            g2d.fillRect((int)cx - halfPoint, (int)cy - halfPoint, pointSize, pointSize);
            g2d.drawString(String.format("%3$d: %1$.3f, %2$.3f", x, y, c / 2), (int)cx, (int)cy + pointSize + 15);
        }
        g2d.dispose();
        return bim;
    }
}

