/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.swing.AWTFSFont;

public class AWTFontResolver
implements FontResolver {
    private final Map<String, Font> fontsCache = new HashMap<String, Font>();
    private final Set<String> availableFontNames = new HashSet<String>();
    private final Map<String, Font> availableFonts = new HashMap<String, Font>();

    public AWTFontResolver() {
        this.init();
    }

    private void init() {
        this.fontsCache.clear();
        GraphicsEnvironment gfx = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.availableFontNames.clear();
        this.availableFontNames.addAll(Arrays.asList(gfx.getAvailableFontFamilyNames()));
        this.availableFonts.clear();
        this.availableFonts.put("Serif", new Font("Serif", 0, 1));
        this.availableFonts.put("SansSerif", new Font("SansSerif", 0, 1));
        this.availableFonts.put("Monospaced", new Font("Monospaced", 0, 1));
    }

    @Override
    public void flushCache() {
        this.init();
    }

    public FSFont resolveFont(SharedContext ctx, String @Nullable [] families, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        if (families != null) {
            for (String family : families) {
                Font font = this.resolveFont(ctx, family, size, weight, style, variant);
                if (font == null) continue;
                return new AWTFSFont(font);
            }
        }
        String family = "SansSerif";
        if (style == IdentValue.ITALIC) {
            family = "Serif";
        }
        Font fnt = AWTFontResolver.createFont(ctx, this.availableFonts.get(family), size, weight, style, variant);
        this.fontsCache.put(AWTFontResolver.getFontInstanceHashName(ctx, family, size, weight, style, variant), fnt);
        return new AWTFSFont(fnt);
    }

    public void setFontMapping(String name, Font font) {
        this.availableFonts.put(name, font.deriveFont(1.0f));
    }

    protected static Font createFont(SharedContext ctx, Font root_font, float size, @Nullable IdentValue weight, @Nullable IdentValue style, @Nullable IdentValue variant) {
        int font_const = 0;
        if (weight != null && (weight == IdentValue.BOLD || weight == IdentValue.FONT_WEIGHT_700 || weight == IdentValue.FONT_WEIGHT_800 || weight == IdentValue.FONT_WEIGHT_900)) {
            font_const |= 1;
        }
        if (style != null && (style == IdentValue.ITALIC || style == IdentValue.OBLIQUE)) {
            font_const |= 2;
        }
        Font fnt = root_font.deriveFont(font_const, size *= ctx.getTextRenderer().getFontScale());
        if (variant != null && variant == IdentValue.SMALL_CAPS) {
            fnt = fnt.deriveFont((float)((double)fnt.getSize() * 0.6));
        }
        return fnt;
    }

    protected @Nullable Font resolveFont(SharedContext ctx, String font, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String font_instance_name;
        if (font.startsWith("\"")) {
            font = font.substring(1);
        }
        if (font.endsWith("\"")) {
            font = font.substring(0, font.length() - 1);
        }
        if (font.equalsIgnoreCase("serif")) {
            font = "Serif";
        }
        if (font.equalsIgnoreCase("sans-serif")) {
            font = "SansSerif";
        }
        if (font.equalsIgnoreCase("monospace")) {
            font = "Monospaced";
        }
        if (font.equals("Serif") && style == IdentValue.OBLIQUE) {
            font = "SansSerif";
        }
        if (font.equals("SansSerif") && style == IdentValue.ITALIC) {
            font = "Serif";
        }
        if (this.fontsCache.containsKey(font_instance_name = AWTFontResolver.getFontInstanceHashName(ctx, font, size, weight, style, variant))) {
            return this.fontsCache.get(font_instance_name);
        }
        Font root_font = this.availableFonts.get(font);
        if (root_font == null && this.availableFontNames.contains(font)) {
            root_font = new Font(font, 0, 1);
            this.availableFonts.put(font, root_font);
        }
        if (root_font != null) {
            Font fnt = AWTFontResolver.createFont(ctx, root_font, size, weight, style, variant);
            this.fontsCache.put(font_instance_name, fnt);
            return fnt;
        }
        return null;
    }

    protected static String getFontInstanceHashName(SharedContext ctx, String name, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        return name + "-" + size * ctx.getTextRenderer().getFontScale() + "-" + String.valueOf(weight) + "-" + String.valueOf(style) + "-" + String.valueOf(variant);
    }

    @Override
    @CheckReturnValue
    public @Nullable FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(renderingContext, spec.families, spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
    }
}

