/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.FontUtil;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    private static final int DEFAULT_IMAGE_CACHE_SIZE = 16;
    private static final Pattern CLASSPATH_PREFIX = Pattern.compile("classpath:/?");
    protected final Map<String, ImageResource> _imageCache;
    private final int _imageCacheCapacity;
    private @Nullable String _baseURL;

    public NaiveUserAgent() {
        this(16);
    }

    public NaiveUserAgent(int imgCacheSize) {
        this._imageCacheCapacity = imgCacheSize;
        this._imageCache = new LinkedHashMap<String, ImageResource>(this._imageCacheCapacity, 0.75f, true);
    }

    public void shrinkImageCache() {
        int ovr = this._imageCache.size() - this._imageCacheCapacity;
        Iterator<String> it = this._imageCache.keySet().iterator();
        while (it.hasNext() && ovr-- > 0) {
            it.next();
            it.remove();
        }
    }

    public void clearImageCache() {
        this._imageCache.clear();
    }

    @CheckReturnValue
    protected @Nullable InputStream resolveAndOpenStream(@Nullable String uri) {
        String resolvedUri = this.resolveURI(uri);
        try {
            return FontUtil.isEmbeddedBase64Font(uri) ? FontUtil.getEmbeddedBase64Data(uri) : this.openStream(resolvedUri);
        }
        catch (MalformedURLException e) {
            XRLog.exception("bad URL given: " + resolvedUri, e);
        }
        catch (FileNotFoundException e) {
            XRLog.exception("item at URI " + resolvedUri + " not found: " + String.valueOf(e));
        }
        catch (IOException e) {
            XRLog.exception("IO problem for " + resolvedUri, e);
        }
        return null;
    }

    @CheckReturnValue
    protected InputStream openStream(String uri) throws IOException {
        return this.openConnection(uri).getInputStream();
    }

    @CheckReturnValue
    protected URLConnection openConnection(String uri) throws IOException {
        URLConnection connection = new URL(uri).openConnection();
        connection.setRequestProperty("Accept", "*/*");
        if (connection instanceof HttpURLConnection) {
            connection = this.onHttpConnection((HttpURLConnection)connection);
        }
        return connection;
    }

    protected URLConnection onHttpConnection(HttpURLConnection origin) throws MalformedURLException, IOException {
        URLConnection connection = origin;
        int status = origin.getResponseCode();
        if (this.needsRedirect(status)) {
            String newUrl = origin.getHeaderField("Location");
            if (origin.getInstanceFollowRedirects()) {
                XRLog.load("Connection is redirected to: " + newUrl);
                connection = new URL(newUrl).openConnection();
                connection.setRequestProperty("Accept", "*/*");
            } else {
                XRLog.load("Redirect is required but not allowed to: " + newUrl);
            }
        }
        return connection;
    }

    @CheckReturnValue
    protected final boolean needsRedirect(int status) {
        return status == 302 || status == 301 || status == 303;
    }

    @Override
    @CheckReturnValue
    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.resolveAndOpenStream(uri));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CheckReturnValue
    public ImageResource getImageResource(String imageLocation) {
        if (ImageUtil.isEmbeddedBase64Image(imageLocation)) {
            return this.createImageResource(null, ImageUtil.loadEmbeddedBase64Image(imageLocation));
        }
        ImageResource cached = this._imageCache.get(imageLocation);
        if (cached != null) {
            return cached;
        }
        String uri = this.resolveURI(imageLocation);
        try (InputStream is = this.resolveAndOpenStream(uri);){
            if (is == null) return this.createImageResource(uri, null);
            BufferedImage img = ImageIO.read(is);
            if (img == null) {
                throw new IOException("ImageIO.read() returned null for URI %s".formatted(uri));
            }
            ImageResource ir = this.createImageResource(uri, img);
            this._imageCache.put(imageLocation, ir);
            ImageResource imageResource = ir;
            return imageResource;
        }
        catch (FileNotFoundException e) {
            XRLog.exception("Can't read image file; image at URI '%s' not found (caused by: %s)".formatted(uri, e));
            return this.createImageResource(uri, null);
        }
        catch (IOException e) {
            XRLog.exception("Can't read image file; unexpected problem for URI '%s'".formatted(uri), e);
        }
        return this.createImageResource(uri, null);
    }

    @CheckReturnValue
    protected ImageResource createImageResource(@Nullable String uri, @Nullable Image img) {
        return new ImageResource(uri, AWTFSImage.createImage(img));
    }

    @Override
    @CheckReturnValue
    public XMLResource getXMLResource(String uri) {
        XMLResource xMLResource;
        block8: {
            InputStream inputStream = this.resolveAndOpenStream(uri);
            try {
                xMLResource = XMLResource.load(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Can't read XML resource from '%s'".formatted(uri), e);
                }
            }
            inputStream.close();
        }
        return xMLResource;
    }

    @Override
    @CheckReturnValue
    public byte @Nullable [] getBinaryResource(String uri) {
        byte[] byArray;
        block8: {
            InputStream is = this.resolveAndOpenStream(uri);
            try {
                byte[] byArray2 = byArray = is == null ? null : IOUtil.readBytes(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Can't read binary resource from '%s'".formatted(uri), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    @CheckReturnValue
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    @Override
    @CheckReturnValue
    public @Nullable String resolveURI(@Nullable String uri) {
        Exception t;
        if (uri == null) {
            return null;
        }
        if (this._baseURL == null) {
            try {
                URI result = new URI(uri);
                if (result.isAbsolute() && !"file".equals(result.getScheme())) {
                    this.setBaseURL(result.toString());
                }
            }
            catch (URISyntaxException e) {
                XRLog.exception("The default NaiveUserAgent could not use the URL as base url: " + uri, e);
            }
            if (this._baseURL == null) {
                try {
                    this.setBaseURL(new File(System.getProperty("user.dir")).toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for '%s': %s".formatted(uri, e));
                    return null;
                }
            }
        }
        try {
            URI result = new URI(uri);
            if (result.isAbsolute()) {
                block17: {
                    if (result.getScheme().equals("classpath")) {
                        try {
                            return result.toURL().toString();
                        }
                        catch (MalformedURLException e) {
                            URL resource = this.resolveClasspathUrl(uri);
                            if (resource == null) break block17;
                            return resource.toString();
                        }
                    }
                }
                return result.toString();
            }
            XRLog.load(uri + " is not a URL; may be relative. Testing using parent URL " + this._baseURL);
            URI baseURI = new URI(this._baseURL);
            if (!baseURI.isOpaque()) {
                return baseURI.resolve(result).toString();
            }
            try {
                return new URL(new URL(this._baseURL), uri).toExternalForm();
            }
            catch (MalformedURLException ex) {
                t = ex;
            }
        }
        catch (URISyntaxException e) {
            t = e;
        }
        XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL, t);
        return null;
    }

    @CheckReturnValue
    @Nullable URL resolveClasspathUrl(String uri) {
        String path = CLASSPATH_PREFIX.matcher(uri).replaceFirst("");
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }

    @Override
    @CheckReturnValue
    public @Nullable String getBaseURL() {
        return this._baseURL;
    }

    @Override
    public void documentStarted() {
        this.shrinkImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }
}

