/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Objects;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.HSBColor;

public class FSRGBColor
implements FSColor {
    public static final FSRGBColor TRANSPARENT = new FSRGBColor(0, 0, 0);
    public static final FSRGBColor RED = new FSRGBColor(255, 0, 0);
    public static final FSRGBColor GREEN = new FSRGBColor(0, 255, 0);
    public static final FSRGBColor BLUE = new FSRGBColor(0, 0, 255);
    private final int _red;
    private final int _green;
    private final int _blue;
    private final float _alpha;

    public FSRGBColor(int red, int green, int blue) {
        this(red, green, blue, 1.0f);
    }

    public FSRGBColor(int red, int green, int blue, float alpha) {
        this._red = this.validateColor("Red", red);
        this._green = this.validateColor("Green", green);
        this._blue = this.validateColor("Blue", blue);
        this._alpha = this.validateAlpha(alpha);
    }

    private int validateColor(String name, int color) {
        if (color < 0 || color > 255) {
            throw new IllegalArgumentException(String.format("%s %s is out of range [0, 255]", name, color));
        }
        return color;
    }

    private float validateAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException(String.format("alpha %s is out of range [0, 1]", Float.valueOf(alpha)));
        }
        return alpha;
    }

    public FSRGBColor(int color) {
        this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public int getBlue() {
        return this._blue;
    }

    public int getGreen() {
        return this._green;
    }

    public int getRed() {
        return this._red;
    }

    public float getAlpha() {
        return this._alpha;
    }

    public String toString() {
        if (this._alpha != 1.0f) {
            return "rgba(" + this._red + "," + this._green + "," + this._blue + "," + this._alpha + ")";
        }
        return "#" + this.toString(this._red) + this.toString(this._green) + this.toString(this._blue);
    }

    private String toString(int color) {
        return String.format("%02x", color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FSRGBColor)) {
            return false;
        }
        FSRGBColor that = (FSRGBColor)o;
        return this._blue == that._blue && this._green == that._green && this._red == that._red && this._alpha == that._alpha;
    }

    public int hashCode() {
        return Objects.hash(this._red, this._green, this._blue);
    }

    @Override
    @CheckReturnValue
    public FSColor lightenColor() {
        HSBColor hsb = this.toHSB();
        float sLighter = 0.35f * hsb.brightness() * hsb.saturation();
        float bLighter = 0.6999f + 0.3f * hsb.brightness();
        return new HSBColor(hsb.hue(), sLighter, bLighter).toRGB();
    }

    @Override
    @CheckReturnValue
    public FSColor darkenColor() {
        HSBColor hsb = this.toHSB();
        float hBase = hsb.hue();
        float sBase = hsb.saturation();
        float bBase = hsb.brightness();
        float bDarker = 0.56f * bBase;
        return new HSBColor(hBase, sBase, bDarker).toRGB();
    }

    HSBColor toHSB() {
        return FSRGBColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue());
    }

    private static HSBColor RGBtoHSB(int r, int g, int b) {
        float cmax = FSRGBColor.max(r, g, b);
        float cmin = FSRGBColor.min(r, g, b);
        float brightness = cmax / 255.0f;
        float saturation = cmax == 0.0f ? 0.0f : (cmax - cmin) / cmax;
        float hue = saturation == 0.0f ? 0.0f : FSRGBColor.calculateHue(r, g, b, cmax, cmin);
        return new HSBColor(hue, saturation, brightness);
    }

    private static float calculateHue(int r, int g, int b, float cmax, float cmin) {
        float redc = (cmax - (float)r) / (cmax - cmin);
        float greenc = (cmax - (float)g) / (cmax - cmin);
        float bluec = (cmax - (float)b) / (cmax - cmin);
        float hue1 = (float)r == cmax ? bluec - greenc : ((float)g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
        float hue2 = hue1 / 6.0f;
        return hue1 < 0.0f ? hue2 + 1.0f : hue2;
    }

    private static float max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    private static float min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }
}

