/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.awt.Rectangle;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.BorderRadiusCorner;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.newtable.CollapsedBorderValue;

public class BorderPropertySet
extends RectPropertySet {
    private static final Corners NO_CORNERS = new Corners(BorderRadiusCorner.UNDEFINED, BorderRadiusCorner.UNDEFINED, BorderRadiusCorner.UNDEFINED, BorderRadiusCorner.UNDEFINED);
    private static final Styles NO_STYLES = new Styles(null, null, null, null);
    private static final Colors NO_COLORS = new Colors(FSRGBColor.TRANSPARENT, FSRGBColor.TRANSPARENT, FSRGBColor.TRANSPARENT, FSRGBColor.TRANSPARENT);
    public static final BorderPropertySet EMPTY_BORDER = new BorderPropertySet(0.0f, 0.0f, 0.0f, 0.0f, NO_STYLES, NO_CORNERS, NO_COLORS);
    private final Styles styles;
    private final Colors colors;
    private final Corners corners;

    public BorderPropertySet(BorderPropertySet border) {
        this(border.top(), border.right(), border.bottom(), border.left(), border.styles, border.corners, border.colors);
    }

    private BorderPropertySet(float top, float right, float bottom, float left, Styles styles, Corners corners, Colors colors) {
        super(top, right, bottom, left);
        this.styles = styles;
        this.colors = colors;
        this.corners = corners;
    }

    public BorderPropertySet(CollapsedBorderValue top, CollapsedBorderValue right, CollapsedBorderValue bottom, CollapsedBorderValue left) {
        this(top.width(), right.width(), bottom.width(), left.width(), new Styles(top.style(), right.style(), bottom.style(), left.style()), NO_CORNERS, new Colors(top.color(), right.color(), bottom.color(), left.color()));
    }

    private BorderPropertySet(CalculatedStyle style, CssContext ctx) {
        this(BorderPropertySet.calculate(style, CSSName.BORDER_TOP_STYLE, CSSName.BORDER_TOP_WIDTH, ctx), BorderPropertySet.calculate(style, CSSName.BORDER_RIGHT_STYLE, CSSName.BORDER_RIGHT_WIDTH, ctx), BorderPropertySet.calculate(style, CSSName.BORDER_BOTTOM_STYLE, CSSName.BORDER_BOTTOM_WIDTH, ctx), BorderPropertySet.calculate(style, CSSName.BORDER_LEFT_STYLE, CSSName.BORDER_LEFT_WIDTH, ctx), new Styles(style.getIdent(CSSName.BORDER_TOP_STYLE), style.getIdent(CSSName.BORDER_RIGHT_STYLE), style.getIdent(CSSName.BORDER_BOTTOM_STYLE), style.getIdent(CSSName.BORDER_LEFT_STYLE)), new Corners(new BorderRadiusCorner(CSSName.BORDER_TOP_LEFT_RADIUS, style, ctx), new BorderRadiusCorner(CSSName.BORDER_TOP_RIGHT_RADIUS, style, ctx), new BorderRadiusCorner(CSSName.BORDER_BOTTOM_LEFT_RADIUS, style, ctx), new BorderRadiusCorner(CSSName.BORDER_BOTTOM_RIGHT_RADIUS, style, ctx)), new Colors(style.asColor(CSSName.BORDER_TOP_COLOR), style.asColor(CSSName.BORDER_RIGHT_COLOR), style.asColor(CSSName.BORDER_BOTTOM_COLOR), style.asColor(CSSName.BORDER_LEFT_COLOR)));
    }

    private static float calculate(CalculatedStyle style, CSSName borderStyle, CSSName borderWidth, CssContext ctx) {
        return style.isIdent(borderStyle, IdentValue.NONE) || style.isIdent(borderStyle, IdentValue.HIDDEN) ? 0.0f : style.getFloatPropertyProportionalHeight(borderWidth, 0.0f, ctx);
    }

    @Deprecated
    @InlineMe(replacement="this.lighten()")
    public final BorderPropertySet lighten(IdentValue style) {
        return this.lighten();
    }

    public BorderPropertySet lighten() {
        return new BorderPropertySet(this.top(), this.right(), this.bottom(), this.left(), this.styles, this.corners, this.colors.lighten());
    }

    @Deprecated
    @InlineMe(replacement="this.darken()")
    public final BorderPropertySet darken(IdentValue style) {
        return this.darken();
    }

    public BorderPropertySet darken() {
        return new BorderPropertySet(this.top(), this.right(), this.bottom(), this.left(), this.styles, this.corners, this.colors.darken());
    }

    public static BorderPropertySet newInstance(CalculatedStyle style, @Nullable CssContext ctx) {
        BorderPropertySet result = new BorderPropertySet(style, ctx);
        return result.isAllZeros() && !result.hasHidden() && !result.hasBorderRadius() ? EMPTY_BORDER : result;
    }

    @Override
    public String toString() {
        return "BorderPropertySet[top=%s,right=%s,bottom=%s,left=%s]".formatted(Float.valueOf(this.top()), Float.valueOf(this.right()), Float.valueOf(this.bottom()), Float.valueOf(this.left()));
    }

    public boolean noTop() {
        return this.styles.top() == IdentValue.NONE || (int)this.top() == 0;
    }

    public boolean noRight() {
        return this.styles.right() == IdentValue.NONE || (int)this.right() == 0;
    }

    public boolean noBottom() {
        return this.styles.bottom() == IdentValue.NONE || (int)this.bottom() == 0;
    }

    public boolean noLeft() {
        return this.styles.left() == IdentValue.NONE || (int)this.left() == 0;
    }

    @CheckReturnValue
    public @Nullable IdentValue topStyle() {
        return this.styles.top();
    }

    @CheckReturnValue
    public @Nullable IdentValue rightStyle() {
        return this.styles.right();
    }

    @CheckReturnValue
    public @Nullable IdentValue bottomStyle() {
        return this.styles.bottom();
    }

    @CheckReturnValue
    public @Nullable IdentValue leftStyle() {
        return this.styles.left();
    }

    public FSColor topColor() {
        return this.colors.top();
    }

    public FSColor rightColor() {
        return this.colors.right();
    }

    public FSColor bottomColor() {
        return this.colors.bottom();
    }

    public FSColor leftColor() {
        return this.colors.left();
    }

    public boolean hasHidden() {
        return this.styles.hasHidden();
    }

    public boolean hasBorderRadius() {
        return this.getTopLeft().hasRadius() || this.getTopRight().hasRadius() || this.getBottomLeft().hasRadius() || this.getBottomRight().hasRadius();
    }

    public BorderRadiusCorner getBottomRight() {
        return this.corners.bottomRight();
    }

    public BorderRadiusCorner getBottomLeft() {
        return this.corners.bottomLeft();
    }

    public BorderRadiusCorner getTopRight() {
        return this.corners.topRight();
    }

    public BorderRadiusCorner getTopLeft() {
        return this.corners.topLeft();
    }

    public BorderPropertySet normalizedInstance(Rectangle bounds) {
        float factor = 1.0f;
        factor = Math.min(factor, (float)bounds.width / this.getSideLength(this.corners.topLeft(), this.corners.topRight(), bounds.width));
        factor = Math.min(factor, (float)bounds.width / this.getSideLength(this.corners.bottomRight(), this.corners.bottomLeft(), bounds.width));
        factor = Math.min(factor, (float)bounds.height / this.getSideLength(this.corners.topRight(), this.corners.bottomRight(), bounds.height));
        factor = Math.min(factor, (float)bounds.height / this.getSideLength(this.corners.bottomLeft(), this.corners.bottomRight(), bounds.height));
        Corners normalizedCorners = new Corners(new BorderRadiusCorner(factor * this.corners.topLeft().getMaxLeft(bounds.height), factor * this.corners.topLeft().getMaxRight(bounds.width)), new BorderRadiusCorner(factor * this.corners.topRight().getMaxLeft(bounds.width), factor * this.corners.topRight().getMaxRight(bounds.height)), new BorderRadiusCorner(factor * this.corners.bottomRight().getMaxLeft(bounds.height), factor * this.corners.bottomRight().getMaxRight(bounds.width)), new BorderRadiusCorner(factor * this.corners.bottomLeft().getMaxLeft(bounds.width), factor * this.corners.bottomLeft().getMaxRight(bounds.height)));
        return new BorderPropertySet(this.top(), this.right(), this.bottom(), this.left(), this.styles, normalizedCorners, this.colors);
    }

    private float getSideLength(BorderRadiusCorner left, BorderRadiusCorner right, float sideLength) {
        return Math.max(sideLength, left.getMaxRight(sideLength) + right.getMaxLeft(sideLength));
    }

    @Override
    @CheckReturnValue
    public BorderPropertySet resetNegativeValues() {
        return new BorderPropertySet(Math.max(0.0f, this.top()), Math.max(0.0f, this.right()), Math.max(0.0f, this.bottom()), Math.max(0.0f, this.left()), this.styles, this.corners, this.colors);
    }

    private record Styles(@Nullable IdentValue top, @Nullable IdentValue right, @Nullable IdentValue bottom, @Nullable IdentValue left) {
        private boolean hasHidden() {
            return this.top == IdentValue.HIDDEN || this.right == IdentValue.HIDDEN || this.bottom == IdentValue.HIDDEN || this.left == IdentValue.HIDDEN;
        }
    }

    private record Corners(BorderRadiusCorner topLeft, BorderRadiusCorner topRight, BorderRadiusCorner bottomLeft, BorderRadiusCorner bottomRight) {
    }

    private record Colors(FSColor top, FSColor right, FSColor bottom, FSColor left) {
        public Colors lighten() {
            return new Colors(this.top.lightenColor(), this.right.lightenColor(), this.bottom.lightenColor(), this.left.lightenColor());
        }

        public Colors darken() {
            return new Colors(this.top.darkenColor(), this.right.darkenColor(), this.bottom.darkenColor(), this.left.darkenColor());
        }
    }
}

