/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.swing.AWTFSImageFactory;
import org.xhtmlrenderer.util.ImageUtil;

public abstract class AWTFSImage
implements FSImage {
    @Deprecated(forRemoval=true)
    @CheckReturnValue
    public static FSImage createImage(@Nullable Image img) {
        return AWTFSImageFactory.createImage(img);
    }

    protected AWTFSImage() {
    }

    public abstract BufferedImage getImage();

    static final class NullImage
    extends AWTFSImage {
        private static final BufferedImage EMPTY_IMAGE = ImageUtil.createTransparentImage(1, 1);

        NullImage() {
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @CheckReturnValue
        public @NonNull NullImage scale(int width, int height) {
            return this;
        }

        @Override
        public BufferedImage getImage() {
            return EMPTY_IMAGE;
        }
    }

    static class NewAWTFSImage
    extends AWTFSImage {
        private final BufferedImage img;

        public NewAWTFSImage(BufferedImage img) {
            this.img = img;
        }

        @Override
        public int getWidth() {
            return this.img.getWidth(null);
        }

        @Override
        public int getHeight() {
            return this.img.getHeight(null);
        }

        @Override
        public BufferedImage getImage() {
            return this.img;
        }

        @CheckReturnValue
        public AWTFSImage scale(int width, int height) {
            if (width > 0 || height > 0) {
                int currentWith = this.getWidth();
                int currentHeight = this.getHeight();
                int targetWidth = width;
                int targetHeight = height;
                if (targetWidth == -1) {
                    targetWidth = (int)((double)currentWith * ((double)targetHeight / (double)currentHeight));
                }
                if (targetHeight == -1) {
                    targetHeight = (int)((double)currentHeight * ((double)targetWidth / (double)currentWith));
                }
                if (currentWith != targetWidth || currentHeight != targetHeight) {
                    return new NewAWTFSImage(ImageUtil.getScaledInstance(this.img, targetWidth, targetHeight));
                }
            }
            return this;
        }
    }
}

