/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.PageElementPosition;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.BoxRangeHelper;
import org.xhtmlrenderer.layout.BoxRangeLists;
import org.xhtmlrenderer.layout.CollapsedBorderSide;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.newtable.CollapsedBorderValue;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.BoxDimensions;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;

public final class Layer {
    private final @Nullable Layer _parent;
    private final boolean _stackingContext;
    private @Nullable List<Layer> _children;
    private final Box _master;
    private @Nullable Box _end;
    private @Nullable List<BlockBox> _floats;
    private boolean _fixedBackground;
    private boolean _inline;
    private boolean _requiresLayout;
    private final List<PageBox> _pages = new ArrayList<PageBox>();
    private @Nullable PageBox _lastRequestedPage;
    private @Nullable Set<BlockBox> _pageSequences;
    private @Nullable List<BlockBox> _sortedPageSequences;
    private @Nullable Map<String, List<BlockBox>> _runningBlocks;

    public Layer(Box master) {
        this(null, master, true);
    }

    public Layer(@Nullable Layer parent, Box master) {
        this(parent, master, master.getStyle().isPositioned() && !master.getStyle().isAutoZIndex());
    }

    Layer(@Nullable Layer parent, Box master, boolean stackingContext) {
        this._parent = parent;
        this._master = master;
        this._stackingContext = stackingContext;
        master.setLayer(this);
        master.setContainingLayer(this);
    }

    @CheckReturnValue
    public @Nullable Layer getParent() {
        return this._parent;
    }

    @CheckReturnValue
    public boolean isStackingContext() {
        return this._stackingContext;
    }

    @CheckReturnValue
    public int getZIndex() {
        return (int)this._master.getStyle().asFloat(CSSName.Z_INDEX);
    }

    public float getOpacity() {
        return this._master.getStyle().getOpacity();
    }

    @CheckReturnValue
    public Box getMaster() {
        return this._master;
    }

    public synchronized void addChild(Layer layer) {
        if (this._children == null) {
            this._children = new ArrayList<Layer>();
        }
        this._children.add(layer);
    }

    public void addFloat(BlockBox floater) {
        if (this._floats == null) {
            this._floats = new ArrayList<BlockBox>();
        }
        this._floats.add(floater);
        floater.getFloatedBoxData().setDrawingLayer(this);
    }

    public void removeFloat(BlockBox floater) {
        if (this._floats != null) {
            this._floats.remove(floater);
        }
    }

    private void paintFloats(RenderingContext c) {
        if (this._floats != null) {
            for (int i = this._floats.size() - 1; i >= 0; --i) {
                BlockBox floater = this._floats.get(i);
                this.paintAsLayer(c, floater);
            }
        }
    }

    private void paintLayers(RenderingContext c, List<Layer> layers) {
        for (Layer layer : layers) {
            layer.paint(c);
        }
    }

    @CheckReturnValue
    private List<Layer> collectLayers(Width which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        if (which != Width.AUTO) {
            result.addAll(this.getStackingContextLayers(which));
        }
        List<Layer> children = this.getChildren();
        for (Layer child : children) {
            if (child.isStackingContext()) continue;
            if (which == Width.AUTO) {
                result.add(child);
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    @CheckReturnValue
    private List<Layer> getStackingContextLayers(Width which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List<Layer> children = this.getChildren();
        for (Layer target : children) {
            if (!target.isStackingContext()) continue;
            int zIndex = target.getZIndex();
            if (which == Width.NEGATIVE && zIndex < 0) {
                result.add(target);
                continue;
            }
            if (which == Width.POSITIVE && zIndex > 0) {
                result.add(target);
                continue;
            }
            if (which != Width.ZERO || zIndex != 0) continue;
            result.add(target);
        }
        return result;
    }

    @CheckReturnValue
    private List<Layer> getSortedLayers(Width which) {
        List<Layer> result = this.collectLayers(which);
        result.sort(new ZIndexComparator());
        return result;
    }

    private void paintBackgroundsAndBorders(RenderingContext c, List<Box> blocks, @Nullable Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            List<CollapsedBorderSide> borders;
            TableCellBox cell;
            helper.popClipRegions(i);
            Box box = blocks.get(i);
            box.paintBackground(c);
            box.paintBorder(c);
            if (c.debugDrawBoxes() && box instanceof BlockBox) {
                BlockBox blockBox = (BlockBox)box;
                blockBox.paintDebugOutline(c);
            }
            if (collapsedTableBorders != null && box instanceof TableCellBox && (cell = (TableCellBox)box).hasCollapsedPaintingBorder() && (borders = collapsedTableBorders.get(cell)) != null) {
                this.paintCollapsedTableBorders(c, borders);
            }
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(blocks.size());
    }

    private void paintInlineContent(RenderingContext c, List<Box> lines, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getInline());
        for (int i = 0; i < lines.size(); ++i) {
            helper.popClipRegions(i);
            helper.pushClipRegion(c, i);
            ((InlinePaintable)((Object)lines.get(i))).paintInline(c);
        }
        helper.popClipRegions(lines.size());
    }

    private void paintSelection(RenderingContext c, List<Box> lines) {
        if (c.getOutputDevice().isSupportsSelection()) {
            for (Box paintable : lines) {
                if (!(paintable instanceof InlineLayoutBox)) continue;
                InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)paintable;
                inlineLayoutBox.paintSelection(c);
            }
        }
    }

    @CheckReturnValue
    public Dimension getPaintingDimension(LayoutContext c) {
        return this.calcPaintingDimension(c).getOuterMarginCorner();
    }

    public void paint(RenderingContext c) {
        if (this.getMaster().getStyle().isFixed()) {
            this.positionFixedLayer(c);
        }
        if (this.isRootLayer()) {
            this.getMaster().paintRootElementBackground(c);
        }
        if (!this.isInline() && ((BlockBox)this.getMaster()).isReplaced()) {
            this.paintLayerBackgroundAndBorder(c);
            this.paintReplacedElement(c, (BlockBox)this.getMaster());
        } else {
            BoxRangeLists rangeLists = new BoxRangeLists();
            ArrayList<Box> blocks = new ArrayList<Box>();
            ArrayList<Box> lines = new ArrayList<Box>();
            BoxCollector collector = new BoxCollector();
            collector.collect(c, c.getOutputDevice().getClip(), this, blocks, lines, rangeLists);
            if (!this.isInline()) {
                this.paintLayerBackgroundAndBorder(c);
                if (c.debugDrawBoxes()) {
                    ((BlockBox)this.getMaster()).paintDebugOutline(c);
                }
            }
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c, this.getSortedLayers(Width.NEGATIVE));
            }
            Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders = this.collectCollapsedTableBorders(blocks);
            this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders, rangeLists);
            this.paintFloats(c);
            this.paintListMarkers(c, blocks, rangeLists);
            this.paintInlineContent(c, lines, rangeLists);
            this.paintReplacedElements(c, blocks, rangeLists);
            this.paintSelection(c, lines);
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c, this.collectLayers(Width.AUTO));
                this.paintLayers(c, this.getSortedLayers(Width.ZERO));
                this.paintLayers(c, this.getSortedLayers(Width.POSITIVE));
            }
        }
    }

    @CheckReturnValue
    private List<BlockBox> getFloats() {
        return this._floats == null ? Collections.emptyList() : this._floats;
    }

    @CheckReturnValue
    public @Nullable Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        if (this.isRootLayer() || this.isStackingContext()) {
            Box result = this.find(cssCtx, absX, absY, this.getSortedLayers(Width.POSITIVE), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(Width.ZERO), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.collectLayers(Width.AUTO), findAnonymous);
            if (result != null) {
                return result;
            }
        }
        for (int i = 0; i < this.getFloats().size(); ++i) {
            Box floater = this.getFloats().get(i);
            Box result = floater.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        Box result = this.getMaster().find(cssCtx, absX, absY, findAnonymous);
        if (result != null) {
            return result;
        }
        if (this.isRootLayer() || this.isStackingContext()) {
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(Width.NEGATIVE), findAnonymous);
            return result;
        }
        return null;
    }

    @CheckReturnValue
    private @Nullable Box find(CssContext cssCtx, int absX, int absY, List<Layer> layers, boolean findAnonymous) {
        for (int i = layers.size() - 1; i >= 0; --i) {
            Layer l = layers.get(i);
            Box result = l.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @CheckReturnValue
    private @Nullable Map<TableCellBox, List<CollapsedBorderSide>> collectCollapsedTableBorders(List<Box> blocks) {
        List borders;
        HashMap<TableBox, List> cellBordersByTable = new HashMap<TableBox, List>();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet<CollapsedBorderValue> all = new HashSet<CollapsedBorderValue>();
        for (Box b : blocks) {
            TableCellBox cell;
            if (!(b instanceof TableCellBox) || !(cell = (TableCellBox)b).hasCollapsedPaintingBorder()) continue;
            borders = cellBordersByTable.computeIfAbsent(cell.getTable(), k -> new ArrayList());
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.isEmpty()) {
            return null;
        }
        HashMap<TableCellBox, List<CollapsedBorderSide>> result = new HashMap<TableCellBox, List<CollapsedBorderSide>>();
        for (TableCellBox cell : triggerCellsByTable.values()) {
            borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    private void paintCollapsedTableBorders(RenderingContext c, List<CollapsedBorderSide> borders) {
        for (CollapsedBorderSide border : borders) {
            border.getCell().paintCollapsedBorder(c, border.getSide());
        }
    }

    public void paintAsLayer(RenderingContext c, BlockBox startingPoint) {
        BoxRangeLists rangeLists = new BoxRangeLists();
        ArrayList<Box> blocks = new ArrayList<Box>();
        ArrayList<Box> lines = new ArrayList<Box>();
        BoxCollector collector = new BoxCollector();
        collector.collect(c, c.getOutputDevice().getClip(), this, startingPoint, blocks, lines, rangeLists);
        Map<TableCellBox, List<CollapsedBorderSide>> collapsedTableBorders = this.collectCollapsedTableBorders(blocks);
        this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders, rangeLists);
        this.paintListMarkers(c, blocks, rangeLists);
        this.paintInlineContent(c, lines, rangeLists);
        this.paintSelection(c, lines);
        this.paintReplacedElements(c, blocks, rangeLists);
    }

    private void paintListMarkers(RenderingContext c, List<Box> blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            helper.popClipRegions(i);
            BlockBox box = (BlockBox)blocks.get(i);
            box.paintListMarker(c);
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(blocks.size());
    }

    private void paintReplacedElements(RenderingContext c, List<Box> blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            helper.popClipRegions(i);
            BlockBox box = (BlockBox)blocks.get(i);
            if (box.isReplaced()) {
                this.paintReplacedElement(c, box);
            }
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(blocks.size());
    }

    private void positionFixedLayer(RenderingContext c) {
        Rectangle rect = c.getFixedRectangle();
        Box fixed = this.getMaster();
        fixed.setX(0);
        fixed.setY(0);
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        ((BlockBox)fixed).positionAbsolute(c, BlockBox.Position.BOTH);
        fixed.calcPaintingInfo(c, false);
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c) {
        Box box = this.getMaster();
        if (box instanceof BlockBox) {
            BlockBox box2 = (BlockBox)box;
            box2.paintBackground(c);
            box2.paintBorder(c);
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        if (!c.isInteractive() || replaced.getReplacedElement().isRequiresInteractivePaint()) {
            c.getOutputDevice().paintReplacedElement(c, replaced);
        }
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    @CheckReturnValue
    private PaintingInfo calcPaintingDimension(LayoutContext c) {
        this.getMaster().calcPaintingInfo(c, true);
        PaintingInfo result = this.getMaster().getPaintingInfo().copyOf();
        List<Layer> children = this.getChildren();
        for (Layer child : children) {
            CalculatedStyle masterStyle = child.getMaster().getStyle();
            if (masterStyle.isFixed() || !masterStyle.isAbsolute()) continue;
            PaintingInfo info = child.calcPaintingDimension(c);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
        }
        return result;
    }

    public void positionChildren(LayoutContext c) {
        for (Layer child : this.getChildren()) {
            child.position(c);
        }
    }

    private void position(LayoutContext c) {
        if (this.getMaster().getStyle().isAbsolute() && !c.isPrint()) {
            ((BlockBox)this.getMaster()).positionAbsolute(c, BlockBox.Position.BOTH);
        } else if (this.getMaster().getStyle().isRelative() && (this.isInline() || ((BlockBox)this.getMaster()).isInline())) {
            this.getMaster().positionRelative(c);
            if (!this.isInline()) {
                this.getMaster().calcCanvasLocation();
                this.getMaster().calcChildLocations();
            }
        }
    }

    @CheckReturnValue
    private boolean containsFixedLayer() {
        for (Layer child : this.getChildren()) {
            if (!child.getMaster().getStyle().isFixed() && !child.containsFixedLayer()) continue;
            return true;
        }
        return false;
    }

    @CheckReturnValue
    public boolean containsFixedContent() {
        return this._fixedBackground || this.containsFixedLayer();
    }

    public void setFixedBackground(boolean b) {
        this._fixedBackground = b;
    }

    @CheckReturnValue
    public synchronized List<Layer> getChildren() {
        return this._children == null ? Collections.emptyList() : Collections.unmodifiableList(this._children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Layer layer) {
        boolean removed = false;
        Layer layer2 = this;
        synchronized (layer2) {
            if (this._children != null) {
                Iterator<Layer> i = this._children.iterator();
                while (i.hasNext()) {
                    Layer child = i.next();
                    if (child != layer) continue;
                    removed = true;
                    i.remove();
                    break;
                }
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    @CheckReturnValue
    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    @CheckReturnValue
    public @Nullable Box getEnd() {
        return this._end;
    }

    public void setEnd(Box end) {
        this._end = end;
    }

    @CheckReturnValue
    public boolean isRequiresLayout() {
        return this._requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this._requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c) {
        if (c.isPrint()) {
            this.layoutAbsoluteChildren(c);
        }
        if (!this.isInline()) {
            this.positionChildren(c);
        }
    }

    private void layoutAbsoluteChildren(LayoutContext c) {
        ArrayList<Layer> children = new ArrayList<Layer>(this.getChildren());
        if (!children.isEmpty()) {
            LayoutState state = c.captureLayoutState();
            for (Layer layer : children) {
                if (!layer.isRequiresLayout()) continue;
                this.layoutAbsoluteChild(c, layer);
                if (layer.getMaster().getStyle().isAvoidPageBreakInside() && layer.getMaster().crossesPageBreak(c)) {
                    layer.getMaster().reset(c);
                    ((BlockBox)layer.getMaster()).setNeedPageClear(true);
                    this.layoutAbsoluteChild(c, layer);
                    if (layer.getMaster().crossesPageBreak(c)) {
                        layer.getMaster().reset(c);
                        this.layoutAbsoluteChild(c, layer);
                    }
                }
                layer.setRequiresLayout(false);
                layer.finish(c);
                c.getRootLayer().ensureHasPage(c, layer.getMaster());
            }
            c.restoreLayoutState(state);
        }
    }

    private void layoutAbsoluteChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c, BlockBox.Position.BOTH);
            master.positionAbsoluteOnPage(c);
            c.reInit(true);
            ((BlockBox)child.getMaster()).layout(c);
            master.positionAbsolute(c, BlockBox.Position.HORIZONTALLY);
        } else {
            c.reInit(true);
            master.layout(c);
            BoxDimensions before = master.getBoxDimensions();
            master.reset(c);
            BoxDimensions after = master.getBoxDimensions();
            master.setBoxDimensions(before);
            master.positionAbsolute(c, BlockBox.Position.BOTH);
            master.positionAbsoluteOnPage(c);
            master.setBoxDimensions(after);
            c.reInit(true);
            ((BlockBox)child.getMaster()).layout(c);
        }
    }

    @CheckReturnValue
    public List<PageBox> getPages() {
        return this._pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this._pages.get(this._pages.size() - 1) == pageBox;
    }

    public void addPage(CssContext c) {
        List<PageBox> pages = this.getPages();
        int pagesCount = pages.size();
        String pseudoPage = Layer.pseudoPage(pagesCount);
        PageBox pageBox = pages.isEmpty() ? Layer.createPageBox(c, pseudoPage, 0, pagesCount) : Layer.createPageBox(c, pseudoPage, pages.get(pagesCount - 1).getBottom(), pagesCount);
        pages.add(pageBox);
    }

    private static String pseudoPage(int size) {
        if (size == 0) {
            return "first";
        }
        if (size % 2 == 0) {
            return "right";
        }
        return "left";
    }

    public void removeLastPage() {
        PageBox pageBox = this._pages.remove(this._pages.size() - 1);
        if (pageBox == this.getLastRequestedPage()) {
            this.setLastRequestedPage(null);
        }
    }

    @CheckReturnValue
    public static PageBox createPageBox(CssContext c, String pseudoPage) {
        return Layer.createPageBox(c, pseudoPage, 0, 0);
    }

    @CheckReturnValue
    public static PageBox createPageBox(CssContext c, String pseudoPage, int top, int pageNo) {
        String pageName = null;
        if (c instanceof LayoutContext) {
            LayoutContext layoutContext = (LayoutContext)c;
            pageName = layoutContext.getPageName();
        }
        PageInfo pageInfo = c.getCss().getPageStyle(pageName, pseudoPage);
        CalculatedStyle cs = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        return new PageBox(pageInfo, c, cs, top, pageNo);
    }

    @CheckReturnValue
    public @Nullable PageBox getFirstPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY());
    }

    @CanIgnoreReturnValue
    public @Nullable PageBox getLastPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c, Box box) {
        this.getLastPage(c, box);
    }

    @CanIgnoreReturnValue
    public @Nullable PageBox getPage(CssContext c, int yOffset) {
        List<PageBox> pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox lastRequested = this.getLastRequestedPage();
        if (lastRequested != null && yOffset >= lastRequested.getTop() && yOffset < lastRequested.getBottom()) {
            return lastRequested;
        }
        PageBox last = pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            int count = pages.size();
            for (int i = count - 1; i >= 0 && i >= count - 5; --i) {
                PageBox pageBox = pages.get(i);
                if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                this.setLastRequestedPage(pageBox);
                return pageBox;
            }
            int low = 0;
            int high = count - 6;
            while (low <= high) {
                int mid = low + high >> 1;
                PageBox pageBox = pages.get(mid);
                if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                    this.setLastRequestedPage(pageBox);
                    return pageBox;
                }
                if (pageBox.getTop() < yOffset) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        } else {
            this.addPagesUntilPosition(c, yOffset);
            PageBox result = pages.get(pages.size() - 1);
            this.setLastRequestedPage(result);
            return result;
        }
        throw new RuntimeException("internal error");
    }

    private void addPagesUntilPosition(CssContext c, int position) {
        List<PageBox> pages = this.getPages();
        PageBox last = pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c);
            last = pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(int maxYHeight) {
        PageBox page;
        List<PageBox> pages = this.getPages();
        for (int i = pages.size() - 1; i > 0 && (page = pages.get(i)).getTop() >= maxYHeight; --i) {
            if (page == this.getLastRequestedPage()) {
                this.setLastRequestedPage(null);
            }
            pages.remove(i);
        }
    }

    public void trimPageCount(int newPageCount) {
        while (this._pages.size() > newPageCount) {
            PageBox pageBox = this._pages.remove(this._pages.size() - 1);
            if (pageBox != this.getLastRequestedPage()) continue;
            this.setLastRequestedPage(null);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, PagedMode mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, PagedMode mode, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int paintingTop = additionalClearance;
        for (PageBox page : pages) {
            page.setPaintingTop(paintingTop);
            switch (mode.ordinal()) {
                case 0: {
                    page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
                    break;
                }
                case 1: {
                    page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
                }
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int maxWidth = 0;
        for (PageBox page : pages) {
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public @Nullable PageBox getLastPage() {
        List<PageBox> pages = this.getPages();
        return pages.isEmpty() ? null : pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        PageBox page = this.getPage(c, top);
        return bottom >= page.getBottom() - c.getExtraSpaceBottom();
    }

    @CheckReturnValue
    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public void addRunningBlock(BlockBox block) {
        if (this._runningBlocks == null) {
            this._runningBlocks = new HashMap<String, List<BlockBox>>();
        }
        String identifier = block.getStyle().getRunningName();
        List blocks = this._runningBlocks.computeIfAbsent(identifier, k -> new ArrayList());
        blocks.add(block);
        blocks.sort(Comparator.comparingInt(Box::getAbsY));
    }

    public void removeRunningBlock(BlockBox block) {
        if (this._runningBlocks == null) {
            return;
        }
        String identifier = block.getStyle().getRunningName();
        List<BlockBox> blocks = this._runningBlocks.get(identifier);
        if (blocks != null) {
            blocks.remove(block);
        }
    }

    public @Nullable BlockBox getRunningBlock(String identifier, PageBox page, PageElementPosition which) {
        if (this._runningBlocks == null) {
            return null;
        }
        List<BlockBox> blocks = this._runningBlocks.get(identifier);
        if (blocks == null) {
            return null;
        }
        if (which == PageElementPosition.START) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                if (b.getStaticEquivalent().getAbsY() >= page.getTop()) break;
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.FIRST) {
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY < page.getTop() || absY >= page.getBottom()) continue;
                return b;
            }
            return this.getRunningBlock(identifier, page, PageElementPosition.START);
        }
        if (which == PageElementPosition.LAST) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                if (b.getStaticEquivalent().getAbsY() > page.getBottom()) break;
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.LAST_EXCEPT) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY >= page.getTop() && absY < page.getBottom()) {
                    return null;
                }
                if (absY > page.getBottom()) break;
                prev = b;
            }
            return prev;
        }
        throw new RuntimeException("bug: internal error");
    }

    public void layoutPages(LayoutContext c) {
        c.setRootDocumentLayer(c.getRootLayer());
        for (PageBox pageBox : this._pages) {
            pageBox.layout(c);
        }
    }

    public void addPageSequence(BlockBox start) {
        if (this._pageSequences == null) {
            this._pageSequences = new HashSet<BlockBox>();
        }
        this._pageSequences.add(start);
    }

    @CanIgnoreReturnValue
    private @Nullable List<BlockBox> getSortedPageSequences() {
        if (this._pageSequences == null) {
            return null;
        }
        if (this._sortedPageSequences == null) {
            ArrayList<BlockBox> result = new ArrayList<BlockBox>(this._pageSequences);
            result.sort(Comparator.comparingInt(Box::getAbsY));
            this._sortedPageSequences = result;
        }
        return this._sortedPageSequences;
    }

    public int getRelativePageNo(RenderingContext c, int absY) {
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null || sequences.isEmpty()) {
            return initial + this.getPage(c, absY).getPageNo();
        }
        BlockBox pageSequence = this.findPageSequence(sequences, absY);
        int sequenceStartAbsolutePageNo = this.getPage(c, pageSequence.getAbsY()).getPageNo();
        int absoluteRequiredPageNo = this.getPage(c, absY).getPageNo();
        return absoluteRequiredPageNo - sequenceStartAbsolutePageNo;
    }

    @CheckReturnValue
    private @Nullable BlockBox findPageSequence(List<BlockBox> sequences, int absY) {
        for (int i = 0; i < sequences.size(); ++i) {
            BlockBox result = sequences.get(i);
            if (i >= sequences.size() - 1 || sequences.get(i + 1).getAbsY() <= absY) continue;
            return result;
        }
        return null;
    }

    @CheckReturnValue
    public int getRelativePageNo(RenderingContext c) {
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageNo();
        }
        int sequenceStartIndex = this.getPageSequenceStart(sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            return initial + c.getPageNo();
        }
        BlockBox block = sequences.get(sequenceStartIndex);
        return c.getPageNo() - this.getFirstPage(c, block).getPageNo();
    }

    @CheckReturnValue
    public int getRelativePageCount(RenderingContext c) {
        int lastPage;
        BlockBox block;
        int firstPage;
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageCount();
        }
        int sequenceStartIndex = this.getPageSequenceStart(sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            firstPage = 0;
        } else {
            block = sequences.get(sequenceStartIndex);
            firstPage = this.getFirstPage(c, block).getPageNo();
        }
        if (sequenceStartIndex < sequences.size() - 1) {
            block = sequences.get(sequenceStartIndex + 1);
            lastPage = this.getFirstPage(c, block).getPageNo();
        } else {
            lastPage = c.getPageCount();
        }
        int sequenceLength = lastPage - firstPage;
        if (sequenceStartIndex == -1) {
            sequenceLength += initial;
        }
        return sequenceLength;
    }

    @CheckReturnValue
    private int getPageSequenceStart(List<BlockBox> sequences, PageBox page) {
        for (int i = sequences.size() - 1; i >= 0; --i) {
            BlockBox start = sequences.get(i);
            if (start.getAbsY() >= page.getBottom() - 1) continue;
            return i;
        }
        return -1;
    }

    @CheckReturnValue
    private @Nullable PageBox getLastRequestedPage() {
        return this._lastRequestedPage;
    }

    private void setLastRequestedPage(@Nullable PageBox lastRequestedPage) {
        this._lastRequestedPage = lastRequestedPage;
    }

    static enum Width {
        POSITIVE,
        ZERO,
        NEGATIVE,
        AUTO;

    }

    private static class ZIndexComparator
    implements Comparator<Layer> {
        private ZIndexComparator() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            return l1.getZIndex() - l2.getZIndex();
        }
    }

    public static enum PagedMode {
        PAGED_MODE_SCREEN,
        PAGED_MODE_PRINT;

    }
}

