/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.CSSParseException;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.parser.property.AbstractPropertyBuilder;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class ContentPropertyBuilder
extends AbstractPropertyBuilder {
    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<? extends CSSPrimitiveValue> values, StylesheetInfo.Origin origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            IdentValue ident;
            PropertyValue value = (PropertyValue)values.get(0);
            if (value.getCssValueType() == 0) {
                return Collections.emptyList();
            }
            if (value.getPrimitiveType() == 21 && ((ident = this.checkIdent(value)) == IdentValue.NONE || ident == IdentValue.NORMAL)) {
                return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, value, important, origin));
            }
        }
        ArrayList<PropertyValue> resultValues = new ArrayList<PropertyValue>();
        for (CSSPrimitiveValue cSSPrimitiveValue : values) {
            PropertyValue value = (PropertyValue)cSSPrimitiveValue;
            if (value.getOperator() != null) {
                throw new CSSParseException("Found unexpected operator, " + value.getOperator().getExternalName(), -1);
            }
            short type = value.getPrimitiveType();
            if (type == 20) continue;
            if (type == 19) {
                resultValues.add(value);
                continue;
            }
            if (value.getPropertyValueType() == PropertyValue.Type.VALUE_TYPE_FUNCTION) {
                if (!this.isFunctionAllowed(value.getFunction())) {
                    throw new CSSParseException("Function " + value.getFunction().getName() + " is not allowed here", -1);
                }
                resultValues.add(value);
                continue;
            }
            if (type == 21) {
                IdentValue ident = this.checkIdent(value);
                if (ident == IdentValue.OPEN_QUOTE || ident == IdentValue.CLOSE_QUOTE || ident == IdentValue.NO_CLOSE_QUOTE || ident == IdentValue.NO_OPEN_QUOTE) {
                    resultValues.add(value);
                    continue;
                }
                throw new CSSParseException("Identifier " + String.valueOf(ident) + " is not a valid value for the content property", -1);
            }
            throw new CSSParseException(value.getCssText() + " is not a value value for the content property", -1);
        }
        if (!resultValues.isEmpty()) {
            return Collections.singletonList(new PropertyDeclaration(CSSName.CONTENT, new PropertyValue(resultValues), important, origin));
        }
        return Collections.emptyList();
    }

    private boolean isFunctionAllowed(FSFunction function) {
        return function.is("attr") || function.is("counter") || function.is("counters") || function.is("element") || function.getName().startsWith("-fs") || function.is("target-counter") || function.is("leader");
    }
}

