/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.constants;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.IdentValue;

public class MarginBoxName {
    private static final Map<String, MarginBoxName> ALL = new HashMap<String, MarginBoxName>();
    private static int _maxAssigned;
    public final int FS_ID;
    private final String _ident;
    private final IdentValue _textAlign;
    private final IdentValue _verticalAlign;
    public static final MarginBoxName TOP_LEFT_CORNER;
    public static final MarginBoxName TOP_LEFT;
    public static final MarginBoxName TOP_CENTER;
    public static final MarginBoxName TOP_RIGHT;
    public static final MarginBoxName TOP_RIGHT_CORNER;
    public static final MarginBoxName BOTTOM_LEFT_CORNER;
    public static final MarginBoxName BOTTOM_LEFT;
    public static final MarginBoxName BOTTOM_CENTER;
    public static final MarginBoxName BOTTOM_RIGHT;
    public static final MarginBoxName BOTTOM_RIGHT_CORNER;
    public static final MarginBoxName LEFT_TOP;
    public static final MarginBoxName LEFT_MIDDLE;
    public static final MarginBoxName LEFT_BOTTOM;
    public static final MarginBoxName RIGHT_TOP;
    public static final MarginBoxName RIGHT_MIDDLE;
    public static final MarginBoxName RIGHT_BOTTOM;
    public static final MarginBoxName FS_PDF_XMP_METADATA;

    private MarginBoxName(String ident, IdentValue textAlign, IdentValue verticalAlign) {
        this._ident = ident;
        this._textAlign = textAlign;
        this._verticalAlign = verticalAlign;
        this.FS_ID = _maxAssigned++;
    }

    private static MarginBoxName addValue(String ident, IdentValue textAlign, IdentValue verticalAlign) {
        MarginBoxName val = new MarginBoxName(ident, textAlign, verticalAlign);
        ALL.put(ident, val);
        return val;
    }

    public String toString() {
        return this._ident;
    }

    @CheckReturnValue
    public static @Nullable MarginBoxName valueOf(String ident) {
        return ALL.get(ident);
    }

    public int hashCode() {
        return this.FS_ID;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarginBoxName)) {
            return false;
        }
        MarginBoxName marginBoxName = (MarginBoxName)o;
        return this.FS_ID == marginBoxName.FS_ID;
    }

    public IdentValue getInitialTextAlign() {
        return this._textAlign;
    }

    public IdentValue getInitialVerticalAlign() {
        return this._verticalAlign;
    }

    static {
        TOP_LEFT_CORNER = MarginBoxName.addValue("top-left-corner", IdentValue.RIGHT, IdentValue.MIDDLE);
        TOP_LEFT = MarginBoxName.addValue("top-left", IdentValue.LEFT, IdentValue.MIDDLE);
        TOP_CENTER = MarginBoxName.addValue("top-center", IdentValue.CENTER, IdentValue.MIDDLE);
        TOP_RIGHT = MarginBoxName.addValue("top-right", IdentValue.RIGHT, IdentValue.MIDDLE);
        TOP_RIGHT_CORNER = MarginBoxName.addValue("top-right-corner", IdentValue.LEFT, IdentValue.MIDDLE);
        BOTTOM_LEFT_CORNER = MarginBoxName.addValue("bottom-left-corner", IdentValue.RIGHT, IdentValue.MIDDLE);
        BOTTOM_LEFT = MarginBoxName.addValue("bottom-left", IdentValue.LEFT, IdentValue.MIDDLE);
        BOTTOM_CENTER = MarginBoxName.addValue("bottom-center", IdentValue.CENTER, IdentValue.MIDDLE);
        BOTTOM_RIGHT = MarginBoxName.addValue("bottom-right", IdentValue.RIGHT, IdentValue.MIDDLE);
        BOTTOM_RIGHT_CORNER = MarginBoxName.addValue("bottom-right-corner", IdentValue.LEFT, IdentValue.MIDDLE);
        LEFT_TOP = MarginBoxName.addValue("left-top", IdentValue.CENTER, IdentValue.TOP);
        LEFT_MIDDLE = MarginBoxName.addValue("left-middle", IdentValue.CENTER, IdentValue.MIDDLE);
        LEFT_BOTTOM = MarginBoxName.addValue("left-bottom", IdentValue.CENTER, IdentValue.BOTTOM);
        RIGHT_TOP = MarginBoxName.addValue("right-top", IdentValue.CENTER, IdentValue.TOP);
        RIGHT_MIDDLE = MarginBoxName.addValue("right-middle", IdentValue.CENTER, IdentValue.MIDDLE);
        RIGHT_BOTTOM = MarginBoxName.addValue("right-bottom", IdentValue.CENTER, IdentValue.BOTTOM);
        FS_PDF_XMP_METADATA = MarginBoxName.addValue("-fs-pdf-xmp-metadata", IdentValue.TOP, IdentValue.LEFT);
    }
}

