package org.xhtmlrenderer.simple;

import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.Java2DFontContext;
import org.xhtmlrenderer.swing.Java2DOutputDevice;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.FSImageWriter;
import org.xhtmlrenderer.util.ImageUtil;
import org.xml.sax.InputSource;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;

/**
 * @author Yoav Aharoni
 */
public class Test {
	public static void main(String[] args) throws Exception {
		BufferedImage image;
		OutputStream os = null;
		String markup = "<html><body><a style='background: yellow; display: block; position: absolute;top: 30px; left: 30px;' href='http://www.google.com'>hello</a></body></html>";
		DOMParser parser = new DOMParser();
		parser.parse(new InputSource(new StringReader(markup)));
		final Document document = parser.getDocument();

		Java2DRenderer renderer = new Java2DRenderer(document, 1024, 1024);
		renderer.getImage();

		final int defaultHeight = 1000;
		 int width = 800;
		final int imageTypr = BufferedImage.TYPE_INT_RGB;
		 int height = 800; //??

			Rectangle rect = new Rectangle(0, 0, width, defaultHeight);
		UserAgentCallback userAgent = new NaiveUserAgent();
		final SharedContext sharedContext = new SharedContext(userAgent);

		sharedContext.reset();
//		if (Configuration.isTrue("xr.cache.stylesheets", true)) {
//			sharedContext.getCss().flushStyleSheets();
//		} else {
			sharedContext.getCss().flushAllStyleSheets();
//		}

		sharedContext.setBaseURL("");
		sharedContext.setNamespaceHandler(new XhtmlNamespaceHandler());
		sharedContext.getCss().setDocumentContext(
				sharedContext,
				sharedContext.getNamespaceHandler(),
				document,
				new NullUserInterface()
		);



		sharedContext.set_TempCanvas(rect);

		// newLayoutContext
		LayoutContext result = sharedContext.newLayoutContextInstance();
		BufferedImage outputImage = createBufferedImage(width, height, imageTypr);//??
		Java2DOutputDevice outputDevice = new Java2DOutputDevice(outputImage);

		result.setFontContext(new Java2DFontContext(outputDevice.getGraphics()));

		sharedContext.getTextRenderer().setup(result.getFontContext());


		BlockBox root = BoxBuilder.createRootBox(result, document);
		root.setContainingBlock(new ViewportBox(rect));
		root.layout(result);

//		 height = root.getHeight();
		outputImage = createBufferedImage(width, height,imageTypr);
		outputDevice = new Java2DOutputDevice(outputImage);
		Graphics2D newG = (Graphics2D) outputImage.getGraphics();

		RenderingContext rc = sharedContext.newRenderingContextInstance();
		rc.setFontContext(new Java2DFontContext(newG));
		rc.setOutputDevice(outputDevice);
		sharedContext.getTextRenderer().setup(rc.getFontContext());

		root.getLayer().paint(rc);

		newG.dispose();

		image = outputImage;


		os = new BufferedOutputStream(new FileOutputStream("w3c-homepage.png"));
		new FSImageWriter().write(image, os);


		final NodeList elementsByTagName = document.getElementsByTagName("a");
		final Element link = (Element) elementsByTagName.item(0);

	}
		protected static BufferedImage createBufferedImage(int width, int height, int type) {
		BufferedImage image = ImageUtil.createCompatibleBufferedImage(width, height, type);
		ImageUtil.clearImage(image);
		return image;
	}
	private static final class NullUserInterface implements UserInterface {

		public boolean isHover(Element e) {
			return false;
		}

		public boolean isActive(Element e) {
			return false;
		}

		public boolean isFocus(Element e) {
			return false;
		}
	}
}
