/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.InputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyException;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyInputStream
extends InputStream {
    protected final InputStream in;
    private boolean finishedReading = false;
    private int blockSize = 32768;
    private byte[] compressed = new byte[this.blockSize];
    private byte[] uncompressed = new byte[this.blockSize];
    private int uncompressedCursor = 0;
    private int uncompressedLimit = 0;
    private byte[] chunkSizeBuf = new byte[4];

    public SnappyInputStream(InputStream input) throws IOException {
        this.in = input;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int wroteBytes = 0;
        while (wroteBytes < len) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return wroteBytes == 0 ? -1 : wroteBytes;
            }
            int bytesToWrite = Math.min(this.uncompressedLimit - this.uncompressedCursor, len);
            System.arraycopy(this.uncompressed, this.uncompressedCursor, b, off + wroteBytes, bytesToWrite);
            wroteBytes += bytesToWrite;
            this.uncompressedCursor += bytesToWrite;
        }
        return wroteBytes;
    }

    protected boolean hasNextChunk() throws IOException {
        int readBytes;
        if (this.finishedReading) {
            return false;
        }
        this.uncompressedCursor = 0;
        this.uncompressedLimit = 0;
        int chunkSizeDataLen = this.in.read(this.chunkSizeBuf, 0, 4);
        if (chunkSizeDataLen < 4) {
            this.finishedReading = true;
            return false;
        }
        int chunkSize = SnappyOutputStream.readInt(this.chunkSizeBuf, 0);
        if (chunkSize > this.compressed.length) {
            this.compressed = new byte[chunkSize];
        }
        if ((readBytes = this.in.read(this.compressed, 0, chunkSize)) < chunkSize) {
            throw new IOException("failed to read chunk");
        }
        try {
            int actualUncompressedLength;
            int uncompressedLength = Snappy.uncompressedLength(this.compressed, 0, chunkSize);
            if (uncompressedLength > this.uncompressed.length) {
                this.uncompressed = new byte[uncompressedLength];
            }
            if (uncompressedLength != (actualUncompressedLength = Snappy.uncompress(this.compressed, 0, chunkSize, this.uncompressed, 0))) {
                throw new IOException("invalid uncompressed byte size");
            }
            this.uncompressedLimit = actualUncompressedLength;
        }
        catch (SnappyException e) {
            throw new IOException("failed to uncompress the chunk: " + e.getMessage());
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        return this.read(buf, 0, 1);
    }
}

