/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.view;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import java.util.List;
import org.xelevra.architecture.view.DataBindingAdapter;

public class DataBindingRecyclerAdapter<ItemType, BindingType extends ViewDataBinding>
extends RecyclerView.Adapter<BindingViewHolder>
implements DataBindingAdapter<BindingType> {
    protected final List<ItemType> items;
    private final int layoutId;
    private final int itemId;
    private DataBindingAdapter<BindingType> realisation;
    private AdapterView.OnItemClickListener onItemClickListener;

    public DataBindingRecyclerAdapter(List<ItemType> items, int layoutId, int itemId) {
        this.items = items;
        this.layoutId = layoutId;
        this.itemId = itemId;
    }

    public DataBindingRecyclerAdapter(List<ItemType> items, int layoutId, int itemId, DataBindingAdapter<BindingType> realisation) {
        this(items, layoutId, itemId);
        this.realisation = realisation;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public BindingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)this.layoutId, (ViewGroup)parent, (boolean)false);
        this.onCreate(binding);
        final BindingViewHolder result = new BindingViewHolder(binding);
        if (this.onItemClickListener != null) {
            binding.getRoot().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (DataBindingRecyclerAdapter.this.onItemClickListener != null) {
                        DataBindingRecyclerAdapter.this.onItemClickListener.onItemClick(null, view, result.position, (long)view.getId());
                    }
                }
            });
        }
        return result;
    }

    public void onBindViewHolder(BindingViewHolder holder, int position) {
        holder.position = position;
        holder.binding.setVariable(this.itemId, this.items.get(position));
        this.onBind(holder.binding, position);
        holder.binding.executePendingBindings();
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void onCreate(BindingType binding) {
        if (this.realisation != null) {
            this.realisation.onCreate(binding);
        }
    }

    @Override
    public void onBind(BindingType binding, int position) {
        if (this.realisation != null) {
            this.realisation.onBind(binding, position);
        }
    }

    public static class BindingViewHolder
    extends RecyclerView.ViewHolder {
        private ViewDataBinding binding;
        public int position;

        public BindingViewHolder(ViewDataBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }
    }
}

