/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.util;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class RefresherProvider<T> {
    private final Observable<T> refresher;
    private final Subject<Throwable, Throwable> errors;
    private Subject<T, T> subject;
    private AtomicBoolean isRefreshing;

    public RefresherProvider(Observable<T> coldRefreshObservable) {
        this(coldRefreshObservable, null);
    }

    public RefresherProvider(Observable<T> coldRefreshObservable, T defaultValue) {
        this.refresher = coldRefreshObservable;
        this.subject = defaultValue == null ? BehaviorSubject.create().toSerialized() : BehaviorSubject.create(defaultValue).toSerialized();
        this.isRefreshing = new AtomicBoolean(false);
        this.errors = PublishSubject.create().toSerialized();
    }

    public void refresh() {
        if (this.isRefreshing.getAndSet(true)) {
            return;
        }
        this.refresher.materialize().doOnNext(new Action1<Notification<T>>(){

            public void call(Notification<T> notification) {
                if (notification.isOnError()) {
                    RefresherProvider.this.errors.onNext((Object)notification.getThrowable());
                }
            }
        }).filter(new Func1<Notification<T>, Boolean>(){

            public Boolean call(Notification<T> tNotification) {
                return tNotification.isOnNext();
            }
        }).dematerialize().doOnTerminate(new Action0(){

            public void call() {
                RefresherProvider.this.isRefreshing.set(false);
            }
        }).subscribe(new Action1<T>(){

            public void call(T t) {
                RefresherProvider.this.subject.onNext(t);
            }
        });
    }

    public Observable<T> observe() {
        return this.subject.asObservable();
    }

    public Observable<Throwable> errors() {
        return this.errors.asObservable();
    }
}

