/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.util;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ConcurrentModificationException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.xelevra.architecture.util.Synchronously;

public class PreferenceDataProviderFactory {
    private final SharedPreferences preferences;
    private final Gson gson;

    public PreferenceDataProviderFactory(SharedPreferences preferences, Gson gson) {
        this.preferences = preferences;
        this.gson = gson;
    }

    public <T> T create(Class<T> targetInterface, String path) {
        Invocation invocation = new Invocation(path, targetInterface);
        Object result = Proxy.newProxyInstance(targetInterface.getClassLoader(), new Class[]{targetInterface}, (InvocationHandler)invocation);
        invocation.realisation = result;
        return (T)result;
    }

    private class Invocation
    implements InvocationHandler {
        private final String path;
        private final Class targetClass;
        private Object realisation;
        private Lock editorLock = new ReentrantLock(true);
        private SharedPreferences.Editor editor;

        private Invocation(String path, Class targetClass) {
            this.path = path;
            this.targetClass = targetClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
                String key;
                if (objects != null && objects.length > 2) {
                    throw new IllegalArgumentException("Count of parameters must be 0 or 1 (default value)");
                }
                Class<?> returnType = method.getReturnType();
                if (method.getName().startsWith("is")) {
                    if (!returnType.equals(Boolean.class) && !returnType.equals(Boolean.TYPE)) {
                        throw new IllegalArgumentException("Returning type of method " + method.getName() + " must be boolean or " + Boolean.class.getName());
                    }
                    key = this.path + method.getName().substring(2).toLowerCase();
                } else {
                    key = this.path + method.getName().substring(3).toLowerCase();
                }
                Object def = null;
                if (objects != null && objects.length == 1) {
                    if (!returnType.equals(method.getParameterTypes()[0])) {
                        throw new IllegalArgumentException("Type of default value must be equal to returning type. Default value type is " + method.getParameterTypes()[0].getName() + " Returning type is " + returnType.getName());
                    }
                    def = objects[0];
                } else if (objects != null && objects.length == 2) {
                    if (!String.class.equals(method.getParameterTypes()[0])) {
                        throw new IllegalArgumentException("Suffix must be String");
                    }
                    if (objects[0] == null) {
                        throw new IllegalArgumentException("Suffix must not be null");
                    }
                    if (!returnType.equals(method.getParameterTypes()[1])) {
                        throw new IllegalArgumentException("Type of default value must be equal to returning type. Default value type is " + method.getParameterTypes()[1].getName() + " Returning type is " + returnType.getName());
                    }
                    def = objects[1];
                    key = key + objects[0];
                }
                return this.get(returnType, key, def);
            }
            if (method.getName().startsWith("set")) {
                Object value;
                if (objects == null || objects.length == 0 || objects.length > 2) {
                    throw new IllegalArgumentException("Count of parameters must be 1 (value) or 2 (suffix and value)");
                }
                boolean isChained = this.checkTypeOrThrow(method);
                String key = this.path + method.getName().substring(3).toLowerCase();
                if (objects.length == 1) {
                    value = objects[0];
                } else {
                    if (!String.class.equals(method.getParameterTypes()[0])) {
                        throw new IllegalArgumentException("Suffix must be String");
                    }
                    if (objects[0] == null) {
                        throw new IllegalArgumentException("Suffix must not be null");
                    }
                    key = key + objects[0];
                    value = objects[1];
                }
                this.set(method.getParameterTypes()[0], key, value, method.getAnnotation(Synchronously.class) != null);
                if (isChained) {
                    return this.realisation;
                }
            } else if (method.getName().equals("edit")) {
                if (objects != null && objects.length != 0) {
                    throw new IllegalArgumentException("Method can't has any parameters");
                }
                boolean isChained = this.checkTypeOrThrow(method);
                try {
                    this.editorLock.lock();
                    if (this.editor != null) {
                        throw new ConcurrentModificationException();
                    }
                    this.editor = PreferenceDataProviderFactory.this.preferences.edit();
                }
                finally {
                    this.editorLock.unlock();
                }
                if (isChained) {
                    return this.realisation;
                }
            } else if (method.getName().equals("commit")) {
                if (objects != null && objects.length > 0) {
                    throw new IllegalArgumentException("Method can't has any parameters");
                }
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new IllegalArgumentException("Method must returns void");
                }
                try {
                    this.editorLock.lock();
                    if (this.editor == null) {
                        throw new IllegalStateException("The object is not in editor mode");
                    }
                    this.editor.commit();
                    this.editor = null;
                }
                finally {
                    this.editorLock.unlock();
                }
            } else if (method.getName().equals("apply")) {
                if (objects != null && objects.length > 0) {
                    throw new IllegalArgumentException("Method can't has any parameters");
                }
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new IllegalArgumentException("Method must returns void");
                }
                try {
                    this.editorLock.lock();
                    if (this.editor == null) {
                        throw new IllegalStateException("The object is not in editor mode");
                    }
                    this.editor.apply();
                    this.editor = null;
                }
                finally {
                    this.editorLock.unlock();
                }
            } else if (method.getName().equals("clear")) {
                SharedPreferences.Editor editor = PreferenceDataProviderFactory.this.preferences.edit();
                for (String key : PreferenceDataProviderFactory.this.preferences.getAll().keySet()) {
                    if (!key.startsWith(this.path)) continue;
                    editor.remove(key);
                }
                editor.commit();
            } else {
                throw new UnsupportedOperationException();
            }
            return null;
        }

        private Object get(Class type, String key, Object def) {
            switch (type.getName()) {
                case "java.lang.Integer": 
                case "int": {
                    return PreferenceDataProviderFactory.this.preferences.getInt(key, def == null ? 0 : (Integer)def);
                }
                case "java.lang.Float": 
                case "float": {
                    return Float.valueOf(PreferenceDataProviderFactory.this.preferences.getFloat(key, def == null ? 0.0f : (float)((Integer)def).intValue()));
                }
                case "java.lang.Long": 
                case "long": {
                    return PreferenceDataProviderFactory.this.preferences.getLong(key, def == null ? 0L : (Long)def);
                }
                case "java.lang.Boolean": 
                case "boolean": {
                    return PreferenceDataProviderFactory.this.preferences.getBoolean(key, def == null ? false : (Boolean)def);
                }
                case "java.lang.String": {
                    return PreferenceDataProviderFactory.this.preferences.getString(key, (String)def);
                }
            }
            return PreferenceDataProviderFactory.this.gson.fromJson(PreferenceDataProviderFactory.this.preferences.getString(key, null), type);
        }

        @SuppressLint(value={"CommitPrefEdits"})
        private void set(Class type, String key, Object value, boolean synchronously) {
            boolean editorMode;
            this.editorLock.lock();
            boolean bl = editorMode = this.editor != null;
            if (!editorMode) {
                this.editorLock.unlock();
            }
            SharedPreferences.Editor localEditor = editorMode ? this.editor : PreferenceDataProviderFactory.this.preferences.edit();
            switch (type.getName()) {
                case "java.lang.Integer": 
                case "int": {
                    localEditor.putInt(key, ((Integer)value).intValue());
                    break;
                }
                case "java.lang.Float": 
                case "float": {
                    localEditor.putFloat(key, ((Float)value).floatValue());
                    break;
                }
                case "java.lang.Long": 
                case "long": {
                    localEditor.putLong(key, ((Long)value).longValue());
                    break;
                }
                case "java.lang.Boolean": 
                case "boolean": {
                    localEditor.putBoolean(key, ((Boolean)value).booleanValue());
                    break;
                }
                case "java.lang.String": {
                    localEditor.putString(key, (String)value);
                    break;
                }
                default: {
                    localEditor.putString(key, PreferenceDataProviderFactory.this.gson.toJson(value));
                }
            }
            if (editorMode) {
                this.editorLock.unlock();
            } else if (synchronously) {
                localEditor.commit();
            } else {
                localEditor.apply();
            }
        }

        private boolean checkTypeOrThrow(Method method) {
            boolean isChained = method.getReturnType().equals(this.targetClass);
            if (!isChained && !method.getReturnType().equals(Void.TYPE)) {
                throw new IllegalArgumentException("Method must returns void or " + this.targetClass.getName());
            }
            return isChained;
        }
    }
}

