/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.util;

import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class Easy {
    public static final String LOG_NAME = "Easy";
    private static int logLevel = 2;
    private static Stack<Long> times = new Stack();

    public static void setLogLevel(int logLevel) {
        Easy.logLevel = logLevel;
    }

    public static void logD(Object ... values) {
        if (logLevel <= 3) {
            for (String string2 : Easy.createLogStrings(values)) {
                Log.d((String)LOG_NAME, (String)string2);
            }
        }
    }

    public static void logE(Object ... values) {
        if (logLevel <= 6) {
            Log.e((String)LOG_NAME, (String)Easy.getLocation());
            for (String string2 : Easy.createLogStrings(values)) {
                Log.e((String)LOG_NAME, (String)string2);
            }
        }
    }

    public static void logI(Object ... values) {
        if (logLevel <= 4) {
            for (String string2 : Easy.createLogStrings(values)) {
                Log.i((String)LOG_NAME, (String)string2);
            }
        }
    }

    public static void logE(Throwable throwable) {
        if (logLevel <= 6) {
            Log.e((String)LOG_NAME, (String)(Easy.getLocation() + "\n" + Log.getStackTraceString((Throwable)throwable)));
        }
    }

    private static String getLocation() {
        String className = Easy.class.getName();
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        boolean found = false;
        for (StackTraceElement trace : traces) {
            try {
                if (found) {
                    if (trace.getClassName().startsWith(className)) continue;
                    Class.forName(trace.getClassName());
                    return "[" + trace + "]: ";
                }
                if (!trace.getClassName().startsWith(className)) continue;
                found = true;
            }
            catch (ClassNotFoundException e) {
                Log.e((String)"Error Easy", (String)("Error in the logger=" + e));
            }
        }
        return "[]: ";
    }

    private static List<String> createLogStrings(Object[] values) {
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder output = new StringBuilder();
        for (Object v : values) {
            output.append(v);
            output.append(" ");
        }
        String message = output.toString();
        byte[] bytes = message.getBytes();
        if (bytes.length <= 4076) {
            result.add(message);
        } else {
            double parts = Math.ceil((double)bytes.length / 4076.0);
            int substringIndex = (int)((double)message.length() / parts);
            for (int i = 0; i <= message.length(); i += substringIndex) {
                result.add(message.substring(i, Math.min(i + substringIndex, message.length())));
            }
        }
        return result;
    }

    public static void start() {
        times.push(System.currentTimeMillis());
    }

    public static void finish(String description) {
        long now = System.currentTimeMillis();
        Easy.logI(description + Easy.timeString(now - times.pop()));
    }

    public static String timeString(long milliseconds) {
        if (milliseconds < 1000L) {
            return milliseconds + "ms";
        }
        int seconds = (int)(milliseconds / 1000L);
        if (seconds < 60) {
            return seconds + "s " + (milliseconds - (long)(seconds * 1000)) + "ms";
        }
        int minutes = seconds / 60;
        return minutes + "min " + (seconds - minutes * 60) + "s " + (milliseconds - (long)(seconds * 1000)) + "ms";
    }
}

