/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.util;

import java.lang.reflect.Method;
import java.util.HashMap;

public class Dagger2Helper {
    private static HashMap<Class<?>, HashMap<Class<?>, Method>> cache = new HashMap();

    public static <T, S extends T> void inject(Class<T> componentClass, S component, Object target) {
        Class<?> targetClass;
        Method method;
        HashMap<Class<?>, Method> methods = cache.get(componentClass);
        if (methods == null) {
            methods = Dagger2Helper.getInjectors(componentClass);
            cache.put(componentClass, methods);
        }
        if ((method = methods.get(targetClass = target.getClass())) == null) {
            throw new RuntimeException("No " + targetClass + " injector exists in " + componentClass + " component");
        }
        try {
            method.invoke(component, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HashMap<Class<?>, Method> getInjectors(Class componentClass) {
        HashMap methods = new HashMap();
        for (Method method : componentClass.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) continue;
            methods.put(params[0], method);
        }
        return methods;
    }
}

