/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.base;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class UIExecutor
implements Executor {
    BlockingQueue<Runnable> commands;
    Handler handler;
    private final Object readyLock;
    private boolean ready;
    private Runnable checkAndRun = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = UIExecutor.this.readyLock;
            synchronized (object) {
                if (!UIExecutor.this.ready) {
                    return;
                }
            }
            UIExecutor.this.runCommands();
        }
    };

    public UIExecutor() {
        this.commands = new LinkedBlockingQueue<Runnable>();
        this.readyLock = new Object();
        this.handler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Not main thread");
        }
        Object object = this.readyLock;
        synchronized (object) {
            this.ready = true;
        }
        this.runCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Not main thread");
        }
        Object object = this.readyLock;
        synchronized (object) {
            this.ready = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        boolean isReady;
        Object object = this.readyLock;
        synchronized (object) {
            isReady = this.ready && Thread.currentThread() == Looper.getMainLooper().getThread();
        }
        if (isReady) {
            command.run();
        } else {
            this.executeNextFrame(command);
        }
    }

    public void executeNextFrame(Runnable command) {
        this.commands.add(command);
        this.handler.postDelayed(this.checkAndRun, 1L);
    }

    private void runCommands() {
        Runnable command;
        while ((command = (Runnable)this.commands.poll()) != null) {
            command.run();
        }
    }
}

