/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.base;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import java.util.HashSet;
import java.util.Random;
import org.xelevra.architecture.util.Easy;

public class FragmentStack {
    private FragmentManager manager;
    private int containerId;
    private Random random;
    private FragmentManager.OnBackStackChangedListener listener;
    public static final String SAVE_TAG_FOR_ARGUMENTS = "_SAVE_TAG_FOR_ARGUMENTS";

    public FragmentStack(FragmentManager manager, int containerId) {
        this.manager = manager;
        this.containerId = containerId;
        this.random = new Random(System.currentTimeMillis());
    }

    public void setOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
        if (this.listener != null) {
            this.manager.removeOnBackStackChangedListener(this.listener);
        }
        this.listener = listener;
        this.manager.addOnBackStackChangedListener(listener);
    }

    public void push(Fragment fragment) {
        FragmentTransaction transaction = this.manager.beginTransaction();
        String tag = this.setTag(fragment);
        if (this.peek() != null) {
            fragment.getArguments().putString("_before", this.peek().getArguments().getString("_tag"));
        }
        transaction.replace(this.containerId, fragment, tag);
        transaction.addToBackStack(null);
        transaction.commit();
        this.executePendingTransactions();
    }

    public void replace(Fragment fragment) {
        this.popAll();
        this.manager.beginTransaction().replace(this.containerId, fragment, this.setTag(fragment)).commit();
        this.executePendingTransactions();
        if (this.listener != null) {
            this.listener.onBackStackChanged();
        }
    }

    public boolean pop() {
        if (this.manager.getBackStackEntryCount() == 0) {
            return false;
        }
        this.manager.popBackStack();
        return true;
    }

    public void popReturnArgs(Bundle args) {
        String tag = this.peek().getArguments().getString("_before", null);
        if (tag == null) {
            throw new RuntimeException("Can not find link to previous fragment");
        }
        Fragment pre = this.manager.findFragmentByTag(tag);
        if (pre == null) {
            throw new RuntimeException("Previous fragment not found");
        }
        Bundle arguments = pre.getArguments();
        if (arguments == null) {
            throw new RuntimeException("Can not set arguments");
        }
        FragmentStack.removeSystemTags(args);
        args.putBoolean(SAVE_TAG_FOR_ARGUMENTS, true);
        arguments.putAll(args);
        this.manager.popBackStack();
    }

    public void popAll() {
        for (int i = this.manager.getBackStackEntryCount(); i > 0; --i) {
            this.manager.popBackStackImmediate();
        }
        if (this.peek() != null) {
            this.manager.beginTransaction().remove(this.peek()).commit();
        }
        this.executePendingTransactions();
        if (this.listener != null) {
            this.listener.onBackStackChanged();
        }
    }

    public Fragment peek() {
        return this.manager.findFragmentById(this.containerId);
    }

    private String setTag(Fragment fragment) {
        String tag = this.random.nextLong() + "" + System.nanoTime();
        if (fragment.getArguments() == null) {
            fragment.setArguments(new Bundle());
        }
        fragment.getArguments().putString("_tag", tag);
        return tag;
    }

    public static void removeSystemTags(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        HashSet keys = new HashSet(bundle.keySet());
        for (String key : keys) {
            if (!key.startsWith("_")) continue;
            bundle.remove(key);
        }
    }

    private void executePendingTransactions() {
        try {
            this.manager.executePendingTransactions();
        }
        catch (IllegalStateException e) {
            Easy.logE(e.toString());
        }
    }
}

