/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.base;

import android.view.View;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.xelevra.architecture.base.FormField;
import org.xelevra.architecture.util.Easy;

public abstract class ErrorHandler {
    public abstract void handleError(Throwable var1, Object var2);

    protected abstract String parseServerError(Object var1, Object var2);

    static View findErrorField(String tag, Object errorObject) {
        if (errorObject instanceof View) {
            return ((View)errorObject).findViewWithTag((Object)tag);
        }
        for (Field field : errorObject.getClass().getDeclaredFields()) {
            if (!View.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                View object = (View)field.get(errorObject);
                field.setAccessible(false);
                if (object != null && tag.equals(object.getTag())) {
                    return object;
                }
                for (Annotation annotation : field.getAnnotations()) {
                    if (!(annotation instanceof FormField)) continue;
                    for (String annotatedTag : ((FormField)annotation).value()) {
                        if (!tag.equals(annotatedTag)) continue;
                        return object;
                    }
                }
            }
            catch (IllegalAccessException e) {
                Easy.logE(e);
            }
        }
        return null;
    }
}

