/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.base;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.TextView;
import icepick.Icepick;
import icepick.State;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.xelevra.architecture.R;
import org.xelevra.architecture.base.BaseActivity;
import org.xelevra.architecture.base.ErrorHandler;
import org.xelevra.architecture.base.FragmentStack;
import org.xelevra.architecture.base.UIExecutor;
import org.xelevra.architecture.util.Easy;
import org.xelevra.architecture.util.Toaster;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.util.SubscriptionList;
import rx.schedulers.Schedulers;

public abstract class BaseFragment<T extends ViewDataBinding>
extends Fragment {
    Toaster toaster;
    protected Scheduler uiScheduler;
    protected int layoutId;
    protected Map<String, View> savable;
    @State
    protected int titleId;
    @State
    protected String title;
    protected int sidebarId;
    private Bundle transactionSavedState;
    private SubscriptionList viewSubscriptions;
    private SubscriptionList fragmentSubscriptions;
    private AlertDialog alert;
    private UIExecutor uiExecutor = new UIExecutor();
    protected ErrorHandler errorHandler;
    private T binding;

    public BaseFragment() {
        this.uiScheduler = Schedulers.from((Executor)this.uiExecutor);
        super.setArguments(new Bundle());
        this.savable = new HashMap<String, View>();
        this.transactionSavedState = new Bundle();
        this.setRetainInstance(true);
    }

    protected T getBinding() {
        return this.binding;
    }

    public void setArguments(Bundle args) {
        Bundle clone = new Bundle(args);
        FragmentStack.removeSystemTags(clone);
        this.getArguments().putAll(args);
    }

    public void addFragmentSubscription(Subscription s) {
        this.fragmentSubscriptions.add(s);
    }

    public void addViewSubscription(Subscription s) {
        this.viewSubscriptions.add(s);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.layoutId == 0) {
            String resName = "screen_" + ((Object)((Object)this)).getClass().getSimpleName().replace("Fragment", "").toLowerCase();
            Easy.logD("Creating fragment view. Name", resName);
            this.layoutId = this.getResources().getIdentifier(resName, "layout", this.getActivity().getPackageName());
            if (this.layoutId <= 0) {
                throw new IllegalStateException("screen name not follow Name Convention or resource " + resName + " not exists");
            }
        }
        this.binding = DataBindingUtil.inflate((LayoutInflater)inflater, (int)this.layoutId, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    protected void showAlert(int message) {
        this.alert = new AlertDialog.Builder((Context)this.getActivity()).setMessage(message).setPositiveButton(17039370, null).show();
    }

    protected void showAlert(String message) {
        this.alert = new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)message).setPositiveButton(17039370, null).create();
        this.alert.show();
    }

    protected void showLargeAlert(CharSequence message) {
        ViewGroup view = (ViewGroup)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.dialog_message, null, false);
        TextView message_TV = (TextView)view.getChildAt(0);
        this.alert = new AlertDialog.Builder((Context)this.getActivity()).setView((View)view).setPositiveButton(17039370, null).create();
        message_TV.setText(message);
        this.alert.show();
    }

    private void dismissAlert() {
        if (this.alert != null) {
            this.alert.dismiss();
            this.alert = null;
        }
    }

    protected void showToast(String message) {
        if (this.toaster == null) {
            this.toaster = new Toaster(this.getActivity().getApplicationContext());
        }
        this.toaster.toast(message);
    }

    protected void showToast(int resId) {
        if (this.toaster == null) {
            this.toaster = new Toaster(this.getActivity().getApplicationContext());
        }
        this.toaster.toast(resId);
    }

    public FragmentStack getFragmentStack() {
        return ((BaseActivity)this.getActivity()).getFragmentStack();
    }

    public void onFragmentResult() {
    }

    public void post(Runnable command) {
        this.uiExecutor.executeNextFrame(command);
    }

    public int getSidebarId() {
        return this.sidebarId;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.fragmentSubscriptions = new SubscriptionList();
    }

    public void onResume() {
        super.onResume();
        this.uiExecutor.ready();
        if (this.getArguments().getBoolean("_SAVE_TAG_FOR_ARGUMENTS")) {
            this.getArguments().remove("_SAVE_TAG_FOR_ARGUMENTS");
            this.onFragmentResult();
        }
    }

    private ActionBar getActionBar() {
        return ((BaseActivity)this.getActivity()).getSupportActionBar();
    }

    public void onPause() {
        this.uiExecutor.pause();
        super.onPause();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Icepick.saveInstanceState((Object)((Object)this), (Bundle)bundle);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        Icepick.restoreInstanceState((Object)((Object)this), (Bundle)savedInstanceState);
        this.viewSubscriptions = new SubscriptionList();
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        if (this.title != null) {
            actionBar.setTitle((CharSequence)this.title);
        } else if (this.titleId != 0) {
            actionBar.setTitle(this.titleId);
        }
    }

    public void onViewStateRestored(Bundle bundle) {
        super.onViewStateRestored(bundle);
        if (!this.transactionSavedState.isEmpty()) {
            this.restoreViewsStates(this.transactionSavedState);
        } else if (bundle != null) {
            this.restoreViewsStates(bundle);
        }
    }

    public void onDestroyView() {
        this.saveViewsStates(this.transactionSavedState);
        this.savable.clear();
        super.onDestroyView();
        this.viewSubscriptions.unsubscribe();
        this.viewSubscriptions.clear();
        this.binding = null;
    }

    public void onDestroy() {
        this.fragmentSubscriptions.unsubscribe();
        this.fragmentSubscriptions.clear();
        super.onDestroy();
    }

    protected void saveViewsStates(Bundle bundle) {
        for (Map.Entry<String, View> entry : this.savable.entrySet()) {
            if (entry.getValue() instanceof ListView) {
                bundle.putInt(entry.getKey(), ((ListView)entry.getValue()).getFirstVisiblePosition());
                continue;
            }
            if (entry.getValue() instanceof RecyclerView) {
                bundle.putParcelable(entry.getKey(), ((RecyclerView)entry.getValue()).getLayoutManager().onSaveInstanceState());
                continue;
            }
            if (entry.getValue() instanceof EditText) {
                String error;
                EditText et = (EditText)entry.getValue();
                bundle.putString(entry.getKey(), et.getText().toString());
                if (et.getError() == null || (error = et.getError().toString()).isEmpty()) continue;
                bundle.putString(entry.getKey() + "_error", error);
                continue;
            }
            if (entry.getValue() instanceof CheckBox) {
                bundle.putBoolean(entry.getKey(), ((CheckBox)entry.getValue()).isChecked());
                continue;
            }
            if (entry.getValue() instanceof TextView) {
                bundle.putString(entry.getKey(), ((TextView)entry.getValue()).getText().toString());
                continue;
            }
            if (entry.getValue() instanceof ViewPager) {
                bundle.putInt(entry.getKey(), ((ViewPager)entry.getValue()).getCurrentItem());
                continue;
            }
            if (!(entry.getValue() instanceof GridView)) continue;
            bundle.putInt(entry.getKey(), ((GridView)entry.getValue()).getFirstVisiblePosition());
        }
    }

    protected void restoreViewsStates(Bundle bundle) {
        if (this.getBinding() != null) {
            this.getBinding().executePendingBindings();
        }
        for (Map.Entry<String, View> entry : this.savable.entrySet()) {
            if (!bundle.containsKey(entry.getKey())) continue;
            if (entry.getValue() instanceof ListView) {
                ((ListView)entry.getValue()).setSelection(bundle.getInt(entry.getKey(), 0));
                continue;
            }
            if (entry.getValue() instanceof RecyclerView) {
                ((RecyclerView)entry.getValue()).getLayoutManager().onRestoreInstanceState(bundle.getParcelable(entry.getKey()));
                continue;
            }
            if (entry.getValue() instanceof EditText) {
                EditText et = (EditText)entry.getValue();
                et.setText((CharSequence)bundle.getString(entry.getKey()));
                String error = bundle.getString(entry.getKey() + "_error", null);
                if (error == null) continue;
                et.setError((CharSequence)error);
                continue;
            }
            if (entry.getValue() instanceof CheckBox) {
                ((CheckBox)entry.getValue()).setChecked(bundle.getBoolean(entry.getKey(), false));
                continue;
            }
            if (entry.getValue() instanceof TextView) {
                ((TextView)entry.getValue()).setText((CharSequence)bundle.getString(entry.getKey(), ""));
                continue;
            }
            if (entry.getValue() instanceof ViewPager) {
                ((ViewPager)entry.getValue()).setCurrentItem(bundle.getInt(entry.getKey()));
                continue;
            }
            if (entry.getValue() instanceof GridView) {
                ((GridView)entry.getValue()).setSelection(bundle.getInt(entry.getKey()));
                continue;
            }
            throw new RuntimeException("Restoring state for " + entry.getValue().getClass().getCanonicalName() + " not implemented");
        }
    }

    public Scheduler getUiScheduler() {
        return this.uiScheduler;
    }

    protected abstract class FragmentSubscription<T>
    extends AutoSubscription<T> {
        protected FragmentSubscription() {
            BaseFragment.this.fragmentSubscriptions.add((Subscription)this);
        }
    }

    protected abstract class ViewSubscription<T>
    extends AutoSubscription<T> {
        protected ViewSubscription() {
            BaseFragment.this.viewSubscriptions.add((Subscription)this);
        }
    }

    private abstract class AutoSubscription<T>
    extends Subscriber<T> {
        private AutoSubscription() {
        }

        public void onCompleted() {
        }

        public void onError(Throwable error) {
            BaseFragment.this.errorHandler.handleError(error, BaseFragment.this.getView());
        }
    }
}

