/*
 * Decompiled with CFR 0.152.
 */
package org.xelevra.architecture.base;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import icepick.Icepick;
import icepick.State;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executor;
import org.xelevra.architecture.base.BackPressedListener;
import org.xelevra.architecture.base.FragmentStack;
import org.xelevra.architecture.base.UIExecutor;
import org.xelevra.architecture.util.Easy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.util.SubscriptionList;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public abstract class BaseActivity
extends AppCompatActivity {
    public static final int CODE_GET_PHOTO_FROM_CAMERA = Integer.parseInt("0000000100000000", 2);
    private FragmentStack fragmentStack;
    private final SubscriptionList subscriptions;
    private final UIExecutor uiExecutor = new UIExecutor();
    private Subject<Bundle, Bundle> photos;
    protected final Scheduler uiScheduler = Schedulers.from((Executor)this.uiExecutor);
    @State
    protected int fragmentsLayoutId;
    @State
    Bundle imageCaptureData;

    public BaseActivity() {
        this.subscriptions = new SubscriptionList();
        this.photos = PublishSubject.create().toSerialized();
    }

    public boolean takePhoto(Bundle data) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(this.getPackageManager()) == null) {
            Easy.logE("Cannot find activity for camera");
            return false;
        }
        this.imageCaptureData = data == null ? new Bundle() : data;
        try {
            File file = this.createImageFile();
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
            this.imageCaptureData.putString("file_name", file.getAbsolutePath());
        }
        catch (IOException e) {
            Easy.logE(e);
            return false;
        }
        this.startActivityForResult(intent, CODE_GET_PHOTO_FROM_CAMERA);
        return true;
    }

    public Observable<Bundle> observeCamera() {
        return this.photos.asObservable();
    }

    public FragmentStack getFragmentStack() {
        return this.fragmentStack;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Icepick.restoreInstanceState((Object)((Object)this), (Bundle)savedInstanceState);
        if (this.fragmentsLayoutId == 0) {
            throw new IllegalArgumentException("Define fragmentsLayoutId");
        }
        this.fragmentStack = new FragmentStack(this.getSupportFragmentManager(), this.fragmentsLayoutId);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.uiExecutor.ready();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onSaveInstanceState(Bundle outState) {
        Icepick.saveInstanceState((Object)((Object)this), (Bundle)outState);
        super.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        if (this.getFragmentStack().peek() instanceof BackPressedListener) {
            if (((BackPressedListener)this.getFragmentStack().peek()).allowBackPress()) {
                super.onBackPressed();
            }
        } else {
            super.onBackPressed();
        }
    }

    protected void onDestroy() {
        this.uiExecutor.pause();
        this.subscriptions.unsubscribe();
        this.subscriptions.clear();
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == CODE_GET_PHOTO_FROM_CAMERA) {
            if (resultCode == -1) {
                this.photos.onNext((Object)this.imageCaptureData);
            }
            this.imageCaptureData = null;
        }
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    protected abstract class ActivitySubscription<T>
    extends Subscriber<T> {
        protected ActivitySubscription() {
            BaseActivity.this.subscriptions.add((Subscription)this);
        }

        public void onCompleted() {
        }

        public void onError(Throwable e) {
            Easy.logE(e);
        }
    }
}

